/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONUtil;
import com.googlecode.jsonplugin.annotations.SMDMethod;
import com.googlecode.jsonplugin.smd.SMD;
import com.googlecode.jsonplugin.smd.SMDMethodParameter;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONResult
implements Result {
    private static final Log log = LogFactory.getLog(JSONResult.class);
    private String defaultEncoding = "ISO-8859-1";
    private List<Pattern> excludeProperties = null;
    private String root;
    private boolean wrapWithComments;
    private boolean enableSMD = false;
    private boolean ignoreHierarchy = true;
    private boolean ignoreSMDMethodInterfaces = true;

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }

    public List<Pattern> getExcludePropertiesList() {
        return this.excludeProperties;
    }

    public void setExcludeProperties(String commaDelim) {
        List<String> excludePatterns = JSONUtil.asList(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(Pattern.compile(pattern));
            }
        }
    }

    public void execute(ActionInvocation invocation) throws Exception {
        ActionContext actionContext = invocation.getInvocationContext();
        HttpServletResponse response = (HttpServletResponse)actionContext.get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try {
            Object rootObject;
            if (this.enableSMD) {
                rootObject = this.writeSMD(invocation);
            } else if (this.root != null) {
                ValueStack stack = invocation.getStack();
                rootObject = stack.findValue(this.root);
            } else {
                rootObject = invocation.getAction();
            }
            String json = JSONUtil.serialize(rootObject, this.excludeProperties, this.ignoreHierarchy);
            JSONUtil.writeJSONToResponse(response, this.defaultEncoding, this.isWrapWithComments(), json, false);
        }
        catch (IOException exception) {
            log.error((Object)exception);
            throw exception;
        }
    }

    private SMD writeSMD(ActionInvocation invocation) {
        Method[] methods;
        ActionContext actionContext = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)actionContext.get((Object)"com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        Object rootObject = null;
        if (this.root != null) {
            ValueStack stack = invocation.getStack();
            rootObject = stack.findValue(this.root);
        } else {
            rootObject = invocation.getAction();
        }
        Class<?> clazz = rootObject.getClass();
        SMD smd = new SMD();
        smd.setServiceUrl(request.getRequestURI());
        com.googlecode.jsonplugin.annotations.SMD smdAnnotation = clazz.getAnnotation(com.googlecode.jsonplugin.annotations.SMD.class);
        if (smdAnnotation != null) {
            smd.setObjectName(smdAnnotation.objectName());
            smd.setServiceType(smdAnnotation.serviceType());
            smd.setVersion(smdAnnotation.version());
        }
        for (Method method : methods = JSONUtil.listSMDMethods(clazz, this.ignoreSMDMethodInterfaces)) {
            SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
            if (smdMethodAnnotation != null && !this.shouldExcludeProperty(method.getName())) {
                String methodName = smdMethodAnnotation.name().length() == 0 ? method.getName() : smdMethodAnnotation.name();
                com.googlecode.jsonplugin.smd.SMDMethod smdMethod = new com.googlecode.jsonplugin.smd.SMDMethod(methodName);
                smd.addSMDMethod(smdMethod);
                int parametersCount = method.getParameterTypes().length;
                if (parametersCount <= 0) continue;
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parametersCount; ++i) {
                    com.googlecode.jsonplugin.annotations.SMDMethodParameter smdMethodParameterAnnotation = this.getSMDMethodParameterAnnotation(parameterAnnotations[i]);
                    String paramName = smdMethodParameterAnnotation != null ? smdMethodParameterAnnotation.name() : "p" + i;
                    smdMethod.addSMDMethodParameter(new SMDMethodParameter(paramName));
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignoring property " + method.getName()));
        }
        return smd;
    }

    private com.googlecode.jsonplugin.annotations.SMDMethodParameter getSMDMethodParameterAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof com.googlecode.jsonplugin.annotations.SMDMethodParameter)) continue;
            return (com.googlecode.jsonplugin.annotations.SMDMethodParameter)annotation;
        }
        return null;
    }

    private boolean shouldExcludeProperty(String expr) {
        if (this.excludeProperties != null) {
            for (Pattern pattern : this.excludeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected String getEncoding() {
        String encoding = this.defaultEncoding;
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public boolean isWrapWithComments() {
        return this.wrapWithComments;
    }

    public void setWrapWithComments(boolean wrapWithComments) {
        this.wrapWithComments = wrapWithComments;
    }

    public boolean isEnableSMD() {
        return this.enableSMD;
    }

    public void setEnableSMD(boolean enableSMD) {
        this.enableSMD = enableSMD;
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setIgnoreSMDMethodInterfaces(boolean ignoreSMDMethodInterfaces) {
        this.ignoreSMDMethodInterfaces = ignoreSMDMethodInterfaces;
    }
}

