/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import com.googlecode.jsonplugin.JSONReader;
import com.googlecode.jsonplugin.JSONWriter;
import com.googlecode.jsonplugin.annotations.SMDMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtil {
    static final String RFC3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Log log = LogFactory.getLog(JSONUtil.class);

    public static String serialize(Object object) throws JSONException {
        JSONWriter writer = new JSONWriter();
        return writer.write(object);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, boolean ignoreHierarchy) throws JSONException {
        JSONWriter writer = new JSONWriter();
        writer.setIgnoreHierarchy(ignoreHierarchy);
        return writer.write(object, excludeProperties);
    }

    public static void serialize(Writer writer, Object object) throws IOException, JSONException {
        writer.write(JSONUtil.serialize(object));
    }

    public static void serialize(Writer writer, Object object, Collection<Pattern> excludeProperties) throws IOException, JSONException {
        writer.write(JSONUtil.serialize(object, excludeProperties, true));
    }

    public static Object deserialize(String json) throws JSONException {
        JSONReader reader = new JSONReader();
        return reader.read(json);
    }

    public static Object deserialize(Reader reader) throws JSONException {
        BufferedReader bufferReader = new BufferedReader(reader);
        String line = null;
        StringBuilder buffer = new StringBuilder();
        try {
            while ((line = bufferReader.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        return JSONUtil.deserialize(buffer.toString());
    }

    public static void writeJSONToResponse(HttpServletResponse response, String encoding, boolean wrapWithComments, String serializedJSON, boolean smd) throws IOException {
        String json;
        String string = json = serializedJSON == null ? "" : serializedJSON;
        if (wrapWithComments) {
            StringBuilder sb = new StringBuilder("/* ");
            sb.append(json);
            sb.append(" */");
            json = sb.toString();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[JSON]" + json));
        }
        response.setContentLength(json.getBytes(encoding).length);
        response.setContentType((smd ? "application/json-rpc;charset=" : "application/json;charset=") + encoding);
        PrintWriter out = response.getWriter();
        out.print(json);
    }

    public static List<String> asList(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] split = commaDelim.split(",");
        for (int i = 0; i < split.length; ++i) {
            String trimmed = split[i].trim();
            if (trimmed.length() <= 0) continue;
            list.add(trimmed);
        }
        return list;
    }

    public static Method[] listSMDMethods(Class clazz, boolean ignoreSMDMethodHierarchy) {
        final LinkedList<Method> methods = new LinkedList<Method>();
        if (ignoreSMDMethodHierarchy) {
            for (Method method : clazz.getMethods()) {
                SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
                if (smdMethodAnnotation == null) continue;
                methods.add(method);
            }
        } else {
            JSONUtil.visitInterfaces(clazz, new ClassVisitor(){

                public boolean visit(Class aClass) {
                    for (Method method : aClass.getMethods()) {
                        SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
                        if (smdMethodAnnotation == null || methods.contains(method)) continue;
                        methods.add(method);
                    }
                    return true;
                }
            });
        }
        Method[] methodResult = new Method[methods.size()];
        return methods.toArray(methodResult);
    }

    public static boolean visitInterfaces(Class aClass, ClassVisitor visitor) {
        LinkedList<Class> classesVisited = new LinkedList<Class>();
        return JSONUtil.visitUniqueInterfaces(aClass, visitor, classesVisited);
    }

    private static boolean visitUniqueInterfaces(Class thisClass, ClassVisitor visitor, List<Class> classesVisited) {
        boolean okayToContinue = true;
        if (!classesVisited.contains(thisClass)) {
            classesVisited.add(thisClass);
            okayToContinue = visitor.visit(thisClass);
            if (okayToContinue) {
                Class superClass;
                Class<?>[] interfaces = thisClass.getInterfaces();
                int index = 0;
                while (index < interfaces.length && okayToContinue) {
                    okayToContinue = JSONUtil.visitUniqueInterfaces(interfaces[index++], visitor, classesVisited);
                }
                if (okayToContinue && (superClass = thisClass.getSuperclass()) != null && !Object.class.equals(superClass)) {
                    okayToContinue = JSONUtil.visitUniqueInterfaces(superClass, visitor, classesVisited);
                }
            }
        }
        return okayToContinue;
    }

    public static interface ClassVisitor {
        public boolean visit(Class var1);
    }
}

