/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import com.googlecode.jsonplugin.annotations.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONWriter {
    private static final Log log = LogFactory.getLog(JSONWriter.class);
    static char[] hex = "0123456789ABCDEF".toCharArray();
    private StringBuilder buf = new StringBuilder();
    private Stack stack = new Stack();
    private boolean ignoreHierarchy = true;
    private Object root;
    private boolean buildExpr = true;
    private String exprStack = "";
    private Collection<Pattern> excludeProperties;
    private DateFormat formatter;

    JSONWriter() {
    }

    public String write(Object object) throws JSONException {
        return this.write(object, null);
    }

    public String write(Object object, Collection<Pattern> excludeProperties) throws JSONException {
        this.buf.setLength(0);
        this.root = object;
        this.exprStack = "";
        this.buildExpr = excludeProperties != null && !excludeProperties.isEmpty();
        this.excludeProperties = excludeProperties;
        this.value(object, null);
        return this.buf.toString();
    }

    private void value(Object object, Method method) throws JSONException {
        if (object == null) {
            this.add("null");
            return;
        }
        if (this.stack.contains(object)) {
            Class<?> clazz = object.getClass();
            if (clazz.isPrimitive() || clazz.equals(String.class)) {
                this.process(object, method);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cyclic reference detected on " + object));
                }
                this.add("null");
            }
            return;
        }
        this.process(object, method);
    }

    private void process(Object object, Method method) throws JSONException {
        this.stack.push(object);
        if (object instanceof Class) {
            this.string(object);
        } else if (object instanceof Boolean) {
            this.bool((Boolean)object);
        } else if (object instanceof Number) {
            this.add(object);
        } else if (object instanceof String) {
            this.string(object);
        } else if (object instanceof Character) {
            this.string(object);
        } else if (object instanceof Map) {
            this.map((Map)object, method);
        } else if (object.getClass().isArray()) {
            this.array(object, method);
        } else if (object instanceof Iterable) {
            this.array(((Iterable)object).iterator(), method);
        } else if (object instanceof Date) {
            this.date((Date)object, method);
        } else if (object instanceof Calendar) {
            this.date(((Calendar)object).getTime(), method);
        } else {
            this.bean(object);
        }
        this.stack.pop();
    }

    private void bean(Object object) throws JSONException {
        this.add("{");
        try {
            Class<?> clazz = object.getClass();
            BeanInfo info = object == this.root && this.ignoreHierarchy ? Introspector.getBeanInfo(clazz, clazz.getSuperclass()) : Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            boolean hasData = false;
            for (int i = 0; i < props.length; ++i) {
                PropertyDescriptor prop = props[i];
                String name = prop.getName();
                Method accessor = prop.getReadMethod();
                Method baseAccessor = null;
                if (clazz.getName().indexOf("$$EnhancerByCGLIB$$") > -1) {
                    try {
                        baseAccessor = Class.forName(clazz.getName().substring(0, clazz.getName().indexOf("$$"))).getDeclaredMethod(accessor.getName(), accessor.getParameterTypes());
                    }
                    catch (Exception ex) {
                        log.debug((Object)ex.getMessage());
                    }
                } else {
                    baseAccessor = accessor;
                }
                if (baseAccessor == null) continue;
                JSON json = baseAccessor.getAnnotation(JSON.class);
                if (json != null) {
                    if (!json.serialize()) continue;
                    if (json.name().length() > 0) {
                        name = json.name();
                    }
                }
                if (this.shouldExcludeProperty(clazz, prop)) continue;
                String expr = null;
                if (this.buildExpr) {
                    expr = this.expandExpr(name);
                    if (this.shouldExcludeProperty(expr)) continue;
                    expr = this.setExprStack(expr);
                }
                if (hasData) {
                    this.add(',');
                }
                hasData = true;
                Object value = accessor.invoke(object, new Object[0]);
                this.add(name, value, accessor);
                if (!this.buildExpr) continue;
                this.setExprStack(expr);
            }
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        this.add("}");
    }

    private boolean shouldExcludeProperty(Class clazz, PropertyDescriptor prop) throws SecurityException, NoSuchFieldException {
        return prop.getName().equals("class");
    }

    private String expandExpr(int i) {
        return this.exprStack + "[" + i + "]";
    }

    private String expandExpr(String property) {
        if (this.exprStack.length() == 0) {
            return property;
        }
        return this.exprStack + "." + property;
    }

    private String setExprStack(String expr) {
        String s = this.exprStack;
        this.exprStack = expr;
        return s;
    }

    private boolean shouldExcludeProperty(String expr) {
        for (Pattern pattern : this.excludeProperties) {
            if (!pattern.matcher(expr).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring property " + expr));
            }
            return true;
        }
        return false;
    }

    private void add(String name, Object value, Method method) throws JSONException {
        this.add('\"');
        this.add(name);
        this.add("\":");
        this.value(value, method);
    }

    private void map(Map map, Method method) throws JSONException {
        this.add("{");
        Iterator it = map.entrySet().iterator();
        boolean hasData = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            String expr = null;
            if (this.buildExpr) {
                if (key == null) {
                    log.error((Object)("Cannot build expression for null key in " + this.exprStack));
                    continue;
                }
                expr = this.expandExpr(key.toString());
                if (this.shouldExcludeProperty(expr)) continue;
                expr = this.setExprStack(expr);
            }
            if (hasData) {
                this.add(',');
            }
            hasData = true;
            this.value(key, method);
            this.add(":");
            this.value(entry.getValue(), method);
            if (!this.buildExpr) continue;
            this.setExprStack(expr);
        }
        this.add("}");
    }

    private void date(Date date, Method method) {
        JSON json = method.getAnnotation(JSON.class);
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
        DateFormat formatter = json != null && json.format().length() > 0 ? new SimpleDateFormat(json.format()) : this.formatter;
        this.string(formatter.format(date));
    }

    private void array(Iterator it, Method method) throws JSONException {
        this.add("[");
        boolean hasData = false;
        int i = 0;
        while (it.hasNext()) {
            block7: {
                String expr;
                block6: {
                    expr = null;
                    if (!this.buildExpr) break block6;
                    expr = this.expandExpr(i);
                    if (this.shouldExcludeProperty(expr)) break block7;
                    expr = this.setExprStack(expr);
                }
                if (hasData) {
                    this.add(',');
                }
                hasData = true;
                this.value(it.next(), method);
                if (this.buildExpr) {
                    this.setExprStack(expr);
                }
            }
            ++i;
        }
        this.add("]");
    }

    private void array(Object object, Method method) throws JSONException {
        this.add("[");
        int length = Array.getLength(object);
        boolean hasData = false;
        for (int i = 0; i < length; ++i) {
            String expr = null;
            if (this.buildExpr) {
                expr = this.expandExpr(i);
                if (this.shouldExcludeProperty(expr)) continue;
                expr = this.setExprStack(expr);
            }
            if (hasData) {
                this.add(',');
            }
            hasData = true;
            this.value(Array.get(object, i), method);
            if (!this.buildExpr) continue;
            this.setExprStack(expr);
        }
        this.add("]");
    }

    private void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    private void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '/') {
                this.add("\\/");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    private void add(Object obj) {
        this.buf.append(obj);
    }

    private void add(char c) {
        this.buf.append(c);
    }

    private void unicode(char c) {
        this.add("\\u");
        int n = c;
        for (int i = 0; i < 4; ++i) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
        }
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }
}

