/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.artemis.sdk;

import com.hikvision.artemis.sdk.Client;
import com.hikvision.artemis.sdk.Request;
import com.hikvision.artemis.sdk.Response;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.hikvision.artemis.sdk.constant.Constants;
import com.hikvision.artemis.sdk.enums.Method;
import com.hikvision.artemis.sdk.util.MessageDigestUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisHttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtemisHttpUtil.class);
    private static final String SUCC_PRE = "2";
    private static final String REDIRECT_PRE = "3";

    public static String doGetArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request request = new Request(Method.GET, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        Response response = ArtemisHttpUtil.execute(request);
        return response.getBody();
    }

    public static String doGetArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, String> querys, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        Request request = new Request(Method.GET, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        Response response = ArtemisHttpUtil.execute(request);
        return response.getBody();
    }

    public static HttpResponse doGetResponse(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object httpResponse = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request request = new Request(Method.GET_RESPONSE, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        Response response = ArtemisHttpUtil.execute(request);
        return response.getResponse();
    }

    public static String doPostFormArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, String> paramMap, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request<String> request = new Request<String>(Method.POST_FORM, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setBodys(paramMap);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doPostFormArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, Object> paramMap, Map<String, String> querys, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        }
        Request<Object> request = new Request<Object>(Method.POST_FORM, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setBodys(paramMap);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static HttpResponse doPostFormImgArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, String> paramMap, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object response = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request<String> request = new Request<String>(Method.POST_FORM_RESPONSE, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setBodys(paramMap);
        Response response1 = ArtemisHttpUtil.execute(request);
        return response1.getResponse();
    }

    public static String doPostStringArtemis(ArtemisConfig artemisConfig, Map<String, String> path, String body, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request request = new Request(Method.POST_STRING, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setStringBody(body);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doPostStringArtemis(ArtemisConfig artemisConfig, Map<String, String> path, String body, Map<String, String> querys, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        Request request = new Request(Method.POST_STRING, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setStringBody(body);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static HttpResponse doPostStringImgArtemis(ArtemisConfig artemisConfig, Map<String, String> path, String body, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request request = new Request(Method.POST_STRING_RESPONSE, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setStringBody(body);
        Response response = ArtemisHttpUtil.execute(request);
        return response.getResponse();
    }

    public static String doPostBytesArtemis(ArtemisConfig artemisConfig, Map<String, String> path, byte[] bytesBody, Map<String, String> querys, String accept, String contentType, Map<String, String> header) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (bytesBody != null) {
            headers.put("Content-MD5", MessageDigestUtil.base64AndMD5(bytesBody));
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        if (header != null) {
            headers.putAll(header);
        }
        Request request = new Request(Method.POST_BYTES, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setBytesBody(bytesBody);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doPostBytesArtemis(ArtemisConfig artemisConfig, Map<String, String> path, byte[] bytesBody, Map<String, String> querys, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (bytesBody != null) {
            headers.put("Content-MD5", MessageDigestUtil.base64AndMD5(bytesBody));
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        Request request = new Request(Method.POST_BYTES, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setBytesBody(bytesBody);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doPostFileFormArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, Object> paramMap, Map<String, String> querys, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "multipart/form-data;charset=UTF-8");
        }
        Request<Object> request = new Request<Object>(Method.POST_FILE, httpSchema + artemisConfig.getHost(), path.get(httpSchema), artemisConfig.getAppKey(), artemisConfig.getAppSecret(), Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        request.setBodys(paramMap);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doPutStringArtemis(ArtemisConfig artemisConfig, Map<String, String> path, String body, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            headers.put("Content-MD5", MessageDigestUtil.base64AndMD5(body));
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        Request request = new Request(Method.PUT_STRING, httpSchema + artemisConfig.host, path.get(httpSchema), artemisConfig.appKey, artemisConfig.appSecret, Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setStringBody(body);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doPutBytesArtemis(ArtemisConfig artemisConfig, Map<String, String> path, byte[] bytesBody, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (bytesBody != null) {
            headers.put("Content-MD5", MessageDigestUtil.base64AndMD5(bytesBody));
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        } else {
            headers.put("Content-Type", "application/text;charset=UTF-8");
        }
        Request request = new Request(Method.PUT_BYTES, httpSchema + artemisConfig.host, path.get(httpSchema), artemisConfig.appKey, artemisConfig.appSecret, Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setBytesBody(bytesBody);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    public static String doDeleteArtemis(ArtemisConfig artemisConfig, Map<String, String> path, Map<String, String> querys, String accept, String contentType) throws Exception {
        String httpSchema = (String)path.keySet().toArray()[0];
        if (httpSchema == null || StringUtils.isEmpty((CharSequence)httpSchema)) {
            throw new RuntimeException("http\u548chttps\u53c2\u6570\u9519\u8befhttpSchema: " + httpSchema);
        }
        Object responseStr = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accept)) {
            headers.put("Accept", accept);
        } else {
            headers.put("Accept", "*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            headers.put("Content-Type", contentType);
        }
        Request request = new Request(Method.DELETE, httpSchema + artemisConfig.host, path.get(httpSchema), artemisConfig.appKey, artemisConfig.appSecret, Constants.DEFAULT_TIMEOUT);
        request.setHeaders(headers);
        request.setQuerys(querys);
        Response response = ArtemisHttpUtil.execute(request);
        return ArtemisHttpUtil.getResponseResult(response);
    }

    private static String getResponseResult(Response response) {
        String responseStr = null;
        int statusCode = response.getStatusCode();
        if (String.valueOf(statusCode).startsWith(SUCC_PRE) || String.valueOf(statusCode).startsWith(REDIRECT_PRE)) {
            responseStr = response.getBody();
        } else {
            String msg = response.getErrorMessage();
            responseStr = response.getBody();
        }
        return responseStr;
    }

    private static Response execute(Request request) throws Exception {
        long startTime = 0L;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("artemis request info: {}", (Object)request);
            startTime = System.currentTimeMillis();
            LOGGER.debug("Start request...");
        }
        Response response = Client.execute(request);
        if (LOGGER.isDebugEnabled()) {
            long time = System.currentTimeMillis() - startTime;
            LOGGER.debug("Complete the request,  time is : {} ms ", (Object)time);
        }
        return response;
    }
}

