/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.IData;
import com.jnrsmcu.sdk.netdevice.ParamItem;
import com.jnrsmcu.sdk.netdevice.ParamManager;
import com.jnrsmcu.sdk.netdevice.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

class Command {
    Command() {
    }

    protected static byte[] getAck(IData data) {
        int deviceId = data.getDeviceId();
        switch (data.getClass().getName()) {
            case "com.jnrsmcu.sdk.netdevice.RealTimeData": {
                byte chk;
                byte[] byArray = new byte[18];
                byArray[0] = 104;
                byArray[1] = -120;
                byArray[2] = -120;
                byArray[3] = -120;
                byArray[4] = -120;
                byArray[5] = -120;
                byArray[6] = -120;
                byArray[7] = 104;
                byArray[8] = 32;
                byArray[9] = 6;
                byArray[10] = 54;
                byArray[11] = 29;
                byArray[17] = 22;
                byte[] res = byArray;
                byte[] address = Utils.getBytesAddress(deviceId);
                System.arraycopy(address, 0, res, 12, 4);
                res[16] = chk = Utils.CheckSum(res, 16);
                return res;
            }
            case "com.jnrsmcu.sdk.netdevice.LoginData": {
                byte chk;
                byte[] byArray = new byte[18];
                byArray[0] = 104;
                byArray[1] = -120;
                byArray[2] = -120;
                byArray[3] = -120;
                byArray[4] = -120;
                byArray[5] = -120;
                byArray[6] = -120;
                byArray[7] = 104;
                byArray[8] = 32;
                byArray[9] = 6;
                byArray[10] = 51;
                byArray[11] = 29;
                byArray[17] = 22;
                byte[] res = byArray;
                byte[] address = Utils.getBytesAddress(deviceId);
                System.arraycopy(address, 0, res, 12, 4);
                res[16] = chk = Utils.CheckSum(res, 16);
                return res;
            }
            case "com.jnrsmcu.sdk.netdevice.StoreData": {
                byte chk;
                byte[] byArray = new byte[18];
                byArray[0] = 104;
                byArray[1] = -120;
                byArray[2] = -120;
                byArray[3] = -120;
                byArray[4] = -120;
                byArray[5] = -120;
                byArray[6] = -120;
                byArray[7] = 104;
                byArray[8] = 32;
                byArray[9] = 6;
                byArray[10] = 60;
                byArray[11] = 29;
                byArray[17] = 22;
                byte[] res = byArray;
                byte[] address = Utils.getBytesAddress(deviceId);
                System.arraycopy(address, 0, res, 12, 4);
                res[16] = chk = Utils.CheckSum(res, 16);
                return res;
            }
            case "com.jnrsmcu.sdk.netdevice.HeartbeatData": {
                byte chk;
                byte[] byArray = new byte[18];
                byArray[0] = 104;
                byArray[1] = -120;
                byArray[2] = -120;
                byArray[3] = -120;
                byArray[4] = -120;
                byArray[5] = -120;
                byArray[6] = -120;
                byArray[7] = 104;
                byArray[8] = 32;
                byArray[9] = 6;
                byArray[10] = 53;
                byArray[11] = 29;
                byArray[17] = 22;
                byte[] res = byArray;
                byte[] address = Utils.getBytesAddress(deviceId);
                System.arraycopy(address, 0, res, 12, 4);
                res[16] = chk = Utils.CheckSum(res, 16);
                return res;
            }
            case "com.jnrsmcu.sdk.netdevice.QW": {
                return Command.qw_ack(deviceId);
            }
        }
        return null;
    }

    protected static byte[] qw_ack(int deviceId) {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.add((byte)104);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)104);
        byteList.add((byte)32);
        byteList.add((byte)0);
        byteList.add((byte)63);
        byteList.add((byte)29);
        byteList.add((byte)51);
        int i = 0;
        while (i < 44) {
            byteList.add((byte)51);
            ++i;
        }
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)22);
        byte[] data = new byte[byteList.size()];
        int i2 = 0;
        while (i2 < byteList.size()) {
            data[i2] = (Byte)byteList.get(i2);
            ++i2;
        }
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, data.length - 6, 4);
        data[9] = (byte)(data.length - 12);
        data[data.length - 2] = Utils.CheckSum(data, data.length - 2);
        return data;
    }

    protected static byte[] getTelecontrolData(int deviceId, int relayId, int opt, int optTime) throws Exception {
        byte chk;
        if (relayId > 15 || relayId < 0) {
            throw new Exception("\u7ee7\u7535\u5668\u7f16\u53f7\u9519\u8bef");
        }
        byte[] byArray = new byte[21];
        byArray[0] = 104;
        byArray[1] = -120;
        byArray[2] = -120;
        byArray[3] = -120;
        byArray[4] = -120;
        byArray[5] = -120;
        byArray[6] = -120;
        byArray[7] = 104;
        byArray[8] = 32;
        byArray[9] = 9;
        byArray[10] = 52;
        byArray[11] = 30;
        byArray[20] = 22;
        byte[] data = byArray;
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, 15, 4);
        data[12] = (byte)(relayId + 51);
        data[13] = (byte)(opt + 51);
        data[14] = (byte)(optTime + 51);
        data[19] = chk = Utils.CheckSum(data, 19);
        return data;
    }

    protected static byte[] getTimmingData(int deviceId) {
        byte chk;
        byte[] byArray = new byte[24];
        byArray[0] = 104;
        byArray[1] = -120;
        byArray[2] = -120;
        byArray[3] = -120;
        byArray[4] = -120;
        byArray[5] = -120;
        byArray[6] = -120;
        byArray[7] = 104;
        byArray[8] = 32;
        byArray[9] = 12;
        byArray[10] = 62;
        byArray[11] = 29;
        byArray[23] = 22;
        byte[] data = byArray;
        Calendar now = Calendar.getInstance();
        data[12] = (byte)(now.get(1) - 2000 + 51);
        data[13] = (byte)(now.get(2) + 51);
        data[14] = (byte)(now.get(5) + 1 + 51);
        data[15] = (byte)(now.get(11) + 51);
        data[16] = (byte)(now.get(12) + 51);
        data[17] = (byte)(now.get(13) + 51);
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, 18, 4);
        data[22] = chk = Utils.CheckSum(data, 22);
        return data;
    }

    protected static byte[] getCallStoreData(int deviceId) {
        byte[] byArray = new byte[18];
        byArray[0] = 104;
        byArray[1] = -120;
        byArray[2] = -120;
        byArray[3] = -120;
        byArray[4] = -120;
        byArray[5] = -120;
        byArray[6] = -120;
        byArray[7] = 104;
        byArray[8] = 32;
        byArray[9] = 6;
        byArray[10] = 61;
        byArray[11] = 29;
        byArray[17] = 22;
        byte[] data = byArray;
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, 12, 4);
        data[16] = Utils.CheckSum(data, 16);
        return data;
    }

    protected static byte[] CallParamList(int deviceId) {
        byte[] byArray = new byte[18];
        byArray[0] = 104;
        byArray[1] = -120;
        byArray[2] = -120;
        byArray[3] = -120;
        byArray[4] = -120;
        byArray[5] = -120;
        byArray[6] = -120;
        byArray[7] = 104;
        byArray[8] = 32;
        byArray[9] = 6;
        byArray[10] = 51;
        byArray[11] = -77;
        byArray[17] = 22;
        byte[] data = byArray;
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, 12, 4);
        data[16] = Utils.CheckSum(data, 16);
        return data;
    }

    protected static byte[] CallParam(int deviceId, List<Short> dictIds) {
        byte dictCount = (byte)(dictIds.size() + 51);
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.add((byte)104);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)104);
        byteList.add((byte)32);
        byteList.add((byte)6);
        byteList.add((byte)52);
        byteList.add((byte)-77);
        byteList.add((byte)0);
        for (short dictId : dictIds) {
            byte[] byteDictId = Utils.getBytes(dictId);
            byteList.add((byte)(byteDictId[0] + 51));
            byteList.add((byte)(byteDictId[1] + 51));
        }
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)22);
        byte[] data = new byte[byteList.size()];
        int i = 0;
        while (i < byteList.size()) {
            data[i] = (Byte)byteList.get(i);
            ++i;
        }
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, data.length - 6, 4);
        data[9] = (byte)(data.length - 12);
        data[12] = dictCount;
        data[data.length - 2] = Utils.CheckSum(data, data.length - 2);
        return data;
    }

    protected static byte[] WriteParam(int deviceId, List<ParamItem> paramList) {
        int dictCount = 51;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.add((byte)104);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)104);
        byteList.add((byte)32);
        byteList.add((byte)6);
        byteList.add((byte)53);
        byteList.add((byte)-77);
        byteList.add((byte)51);
        for (ParamItem item : paramList) {
            byte[] btsDict = ParamManager.getInstance().GetBytes(item);
            if (btsDict == null) continue;
            int i = 0;
            while (i < btsDict.length) {
                byteList.add(btsDict[i]);
                ++i;
            }
            dictCount = (byte)(dictCount + 1);
        }
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)22);
        byte[] data = new byte[byteList.size()];
        int i = 0;
        while (i < byteList.size()) {
            data[i] = (Byte)byteList.get(i);
            ++i;
        }
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, data.length - 6, 4);
        data[9] = (byte)(data.length - 12);
        data[12] = dictCount;
        data[data.length - 2] = Utils.CheckSum(data, data.length - 2);
        return data;
    }

    protected static byte[] Trans(int deviceId, String hexStr) {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.add((byte)104);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)-120);
        byteList.add((byte)104);
        byteList.add((byte)32);
        byteList.add((byte)0);
        byteList.add((byte)54);
        byteList.add((byte)-77);
        byteList.add((byte)0);
        byte[] transData = Utils.getBytes(hexStr.replace(" ", ""));
        int i = 0;
        while (i < transData.length) {
            byteList.add((byte)(transData[i] + 51));
            ++i;
        }
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)0);
        byteList.add((byte)22);
        byte[] data = new byte[byteList.size()];
        int i2 = 0;
        while (i2 < byteList.size()) {
            data[i2] = (Byte)byteList.get(i2);
            ++i2;
        }
        byte[] address = Utils.getBytesAddress(deviceId);
        System.arraycopy(address, 0, data, data.length - 6, 4);
        data[9] = (byte)(data.length - 12);
        data[12] = (byte)(transData.length + 51);
        data[data.length - 2] = Utils.CheckSum(data, data.length - 2);
        return data;
    }
}

