/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

class DataConverter {
    DataConverter() {
    }

    private static String toBinaryString(byte b) {
        return Integer.toBinaryString((b & 0xFF) + 256).substring(1);
    }

    private static byte[] shortToByteArray(short s) {
        byte[] targets = new byte[2];
        int i = 0;
        while (i < 2) {
            int offset = (targets.length - 1 - i) * 8;
            targets[i] = (byte)(s >>> offset & 0xFF);
            ++i;
        }
        return targets;
    }

    private static int toTem(byte temL, byte temH) {
        byte pom = (byte)(temH & 0x80);
        int result = 0;
        if (pom == 0) {
            String temp = String.valueOf(Integer.toHexString(temH & 0x7F)) + (Integer.toHexString(temL).length() <= 1 ? "0" : "") + Integer.toHexString(temL & 0xFF);
            result = Integer.parseInt(temp, 16);
        } else if (pom == -128) {
            String temp = String.valueOf(Integer.toHexString(temH & 0x7F)) + (Integer.toHexString(temL).length() <= 1 ? "0" : "") + Integer.toHexString(temL & 0xFF);
            result = -Integer.parseInt(temp, 16);
        }
        return result;
    }

    private static int toHum(byte humL, byte humH) {
        int res = (humH & 0xFF) << 8 | humL & 0xFF;
        return res;
    }

    protected static int to32S(byte temL, byte temH, byte humL, byte humH) {
        int tem = DataConverter.toTem(temL, temH);
        byte[] sb = DataConverter.shortToByteArray((short)tem);
        int res = (humH & 0xFF) << 24;
        res += (humL & 0xFF) << 16;
        res += (sb[0] & 0xFF) << 8;
        return res += sb[1] & 0xFF;
    }

    protected static long to32U(byte temL, byte temH, byte humL, byte humH) {
        int tem = DataConverter.toTem(temL, temH);
        byte[] sb = DataConverter.shortToByteArray((short)tem);
        String strTem = String.valueOf(DataConverter.toBinaryString(sb[0])) + DataConverter.toBinaryString(sb[1]);
        String str = String.valueOf(DataConverter.toBinaryString(humH)) + DataConverter.toBinaryString(humL) + strTem;
        return Long.parseLong(str, 2);
    }

    protected static float toFloat(byte temL, byte temH, byte humL, byte humH) {
        int tem = DataConverter.toTem(temL, temH);
        byte[] sb = DataConverter.shortToByteArray((short)tem);
        int res = (humH & 0xFF) << 24;
        res += (humL & 0xFF) << 16;
        res += (sb[0] & 0xFF) << 8;
        return Float.intBitsToFloat(res += sb[1] & 0xFF);
    }
}

