/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.DataConverter;
import com.jnrsmcu.sdk.netdevice.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;

public class NodeData {
    private int nodeId;
    private float tem;
    private float hum;
    private Date recordTime;
    private short coordinateType;
    private double lng;
    private double lat;
    private byte temH;
    private byte temL;
    private byte humH;
    private byte humL;

    public int getNodeId() {
        return this.nodeId;
    }

    public float getTem() {
        return this.tem;
    }

    public float getHum() {
        return this.hum;
    }

    public Date getRecordTime() {
        return this.recordTime;
    }

    public short getCoordinateType() {
        return this.coordinateType;
    }

    public double getLng() {
        return this.lng;
    }

    public double getLat() {
        return this.lat;
    }

    public float getFloatValue() {
        try {
            return DataConverter.toFloat(this.temL, this.temH, this.humL, this.humH);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public int getSignedInt32Value() {
        try {
            return DataConverter.to32S(this.temL, this.temH, this.humL, this.humH);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getUnSignedInt32Value() {
        try {
            return DataConverter.to32U(this.temL, this.temH, this.humL, this.humH);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    protected NodeData(byte[] data, Boolean isStoreData) {
        if (data.length > 1) {
            this.nodeId = data[0];
        }
        if (data.length >= 3) {
            this.temH = data[2];
            this.temL = data[1];
            byte temperatureH = data[2];
            byte temperatureL = data[1];
            byte pom = (byte)(temperatureH & 0x80);
            float result = 0.0f;
            if (pom == 0) {
                String temp = String.valueOf(Integer.toHexString(temperatureH & 0x7F)) + (Integer.toHexString(temperatureL).length() <= 1 ? "0" : "") + Integer.toHexString(temperatureL & 0xFF);
                result = Integer.parseInt(temp, 16);
            } else if (pom == -128) {
                String temp = String.valueOf(Integer.toHexString(temperatureH & 0x7F)) + (Integer.toHexString(temperatureL).length() <= 1 ? "0" : "") + Integer.toHexString(temperatureL & 0xFF);
                result = -((float)Integer.parseInt(temp, 16));
            }
            this.tem = result / 10.0f;
        }
        if (data.length >= 5) {
            this.humH = data[4];
            this.humL = data[3];
            String temp = String.valueOf(Integer.toHexString(data[4] & 0xFF)) + (Integer.toHexString(data[3]).length() <= 1 ? "0" : "") + Integer.toHexString(data[3] & 0xFF);
            this.hum = (float)Integer.parseInt(temp, 16) / 10.0f;
        }
        if (data.length > 8) {
            byte[] time = new byte[4];
            System.arraycopy(data, 5, time, 0, 4);
            int ticks = Utils.getInt(time);
            long lticks = ticks - 28800;
            this.recordTime = new Date(lticks * 1000L);
        }
        if (data.length >= 18) {
            byte[] lnglat = new byte[9];
            System.arraycopy(data, 9, lnglat, 0, 9);
            this.resolverLngLat(lnglat);
        }
    }

    private void resolverLngLat(byte[] data) {
        byte posFlag = data[0];
        this.coordinateType = posFlag;
        ByteBuffer lng = ByteBuffer.allocateDirect(4);
        lng = lng.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer lat = ByteBuffer.allocateDirect(4);
        lat = lat.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 4) {
            lng.put(data[i + 1]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            lat.put(data[i + 5]);
            ++i;
        }
        lat.rewind();
        lng.rewind();
        if (this.coordinateType == 1 || this.coordinateType == 2) {
            this.lat = lat.getInt();
            this.lng = lng.getInt();
        } else {
            this.lat = lat.getFloat();
            this.lng = lng.getFloat();
        }
    }
}

