/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.ParamManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.net.util.IPAddressUtil;

public class ParamItem
implements Externalizable {
    private static final long serialVersionUID = -6260156621251332306L;
    private int paramId;
    private String paramType;
    private String description;
    private String value;
    private int length;
    private int minValue;
    private int maxValue;
    private List<KVPair> vdList;
    public Map<String, String> valueDescription;

    public int getParamId() {
        return this.paramId;
    }

    public String getParamType() {
        return this.paramType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getLength() {
        return this.length;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public Map<String, String> getValueDescription() {
        if (this.vdList == null) {
            return null;
        }
        if (this.valueDescription == null) {
            this.valueDescription = new HashMap<String, String>();
            for (KVPair kv : this.vdList) {
                this.valueDescription.put(kv.getKey(), kv.getValue());
            }
        }
        return this.valueDescription;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.paramId = (Integer)in.readObject();
        this.paramType = (String)in.readObject();
        this.description = (String)in.readObject();
        this.length = (Integer)in.readObject();
        this.minValue = (Integer)in.readObject();
        this.maxValue = (Integer)in.readObject();
        Object obj = in.readObject();
        if (!obj.equals("NULL")) {
            this.vdList = (List)obj;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.paramId);
        out.writeObject(this.paramType);
        out.writeObject(this.description);
        out.writeObject(this.length);
        out.writeObject(this.minValue);
        out.writeObject(this.maxValue);
        if (this.vdList == null) {
            out.writeObject("NULL");
        } else {
            out.writeObject(this.vdList);
        }
    }

    public static ParamItem New(int paramId, String value) throws Exception {
        ParamItem item = ParamManager.getInstance().getPararmItem(paramId);
        if (item == null) {
            throw new Exception("\u53c2\u6570\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        if (item.getMaxValue() > item.getMinValue()) {
            double val = 0.0;
            try {
                val = Double.parseDouble(value);
            }
            catch (Exception ex) {
                throw new Exception("\u6570\u636e\u8f93\u5165\u683c\u5f0f\u9519\u8bef");
            }
            if (val < (double)item.getMinValue() || val > (double)item.getMaxValue()) {
                throw new Exception(String.valueOf(item.getDescription()) + "\u53d6\u503c\u8303\u56f4\u5728" + item.getMinValue() + "\u548c" + item.getMaxValue() + "\u4e4b\u95f4");
            }
        }
        if (item.getParamType().equalsIgnoreCase("IP") && !IPAddressUtil.isIPv4LiteralAddress(value)) {
            throw new Exception("IP\u5730\u5740\u683c\u5f0f\u9519\u8bef");
        }
        if (item.getValueDescription() != null && !item.getValueDescription().containsKey(value)) {
            String msg = String.valueOf(item.getDescription()) + "\u53d6\u503c\u8303\u56f4\u5728 ";
            for (String key : item.getValueDescription().keySet()) {
                msg = String.valueOf(msg) + key + ":" + item.getValueDescription().get(key) + "\u3001";
            }
            if (msg.endsWith("\u3001")) {
                msg = msg.substring(0, msg.length() - 1);
            }
            msg = String.valueOf(msg) + "\u4e4b\u95f4";
            throw new Exception(msg);
        }
        ParamItem pi = new ParamItem();
        pi.paramId = paramId;
        pi.setValue(value);
        return pi;
    }

    public class KVPair
    implements Serializable {
        private static final long serialVersionUID = -903828727909826410L;
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

