/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.BinarySerializeOpt;
import com.jnrsmcu.sdk.netdevice.ParamItem;
import com.jnrsmcu.sdk.netdevice.Utils;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ParamManager {
    private static ParamManager instance;
    private Map<Integer, ParamItem> paramCache = new HashMap<Integer, ParamItem>();

    private ParamManager() {
        URL url = ParamManager.class.getProtectionDomain().getCodeSource().getLocation();
        String filePath = null;
        try {
            filePath = URLDecoder.decode(url.getPath(), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (filePath.endsWith(".jar")) {
            filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        File file = new File(filePath);
        filePath = file.getAbsolutePath();
        String path = String.valueOf(filePath) + "/param.dat";
        this.paramCache = (Map)new BinarySerializeOpt().deserialize(path);
    }

    private ParamManager(String filePath) {
        this.paramCache = (Map)new BinarySerializeOpt().deserialize(filePath);
    }

    public static ParamManager getInstance() {
        if (instance == null) {
            instance = new ParamManager();
        }
        return instance;
    }

    public static ParamManager getInstance(String filePath) {
        if (instance == null) {
            instance = new ParamManager(filePath);
        }
        return instance;
    }

    public ParamItem getPararmItem(int dictId) {
        return this.paramCache.containsKey(dictId) ? this.paramCache.get(dictId) : null;
    }

    public List<ParamItem> GetParameters(byte[] data) {
        ArrayList<ParamItem> resList = new ArrayList<ParamItem>();
        int dicIdx = 13;
        int dictCount = (data[12] & 0xFF) - 51;
        int i = 0;
        while (i < dictCount) {
            block51: {
                byte[] dictIdBuff = new byte[]{(byte)(data[dicIdx] - 51), (byte)(data[dicIdx + 1] - 51)};
                short dictId = Utils.getShort(dictIdBuff, 0);
                short dictLen = (short)(data[dicIdx + 2] - 51);
                byte[] value = new byte[dictLen];
                System.arraycopy(data, dicIdx + 3, value, 0, value.length);
                int vIdx = 0;
                while (vIdx < value.length) {
                    value[vIdx] = (byte)(value[vIdx] - 51);
                    ++vIdx;
                }
                dicIdx += 3 + dictLen;
                short id = dictId;
                if (!this.paramCache.containsKey(id)) break block51;
                try {
                    ParamItem dp = this.paramCache.get(id);
                    switch (dp.getParamType().toUpperCase().trim()) {
                        case "INT8S": 
                        case "INT8U": {
                            try {
                                dp.setValue(String.valueOf(value[0]));
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "INT16S": 
                        case "INT16U": {
                            try {
                                dp.setValue(String.valueOf(Utils.getShort(value, 0)));
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "INT32S": 
                        case "INT32U": {
                            try {
                                dp.setValue(String.valueOf(Utils.getInt(value)));
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "FLOAT": {
                            try {
                                dp.setValue(String.valueOf(Utils.getFloat(value, 0)));
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "CHAR": {
                            try {
                                dp.setValue(String.valueOf((char)Utils.getShort(value, 0)));
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "STRING": {
                            try {
                                dp.setValue(new String(value, "GB2312"));
                            }
                            catch (Exception e) {
                                dp.setValue("");
                            }
                            break;
                        }
                        case "IP": {
                            try {
                                String ip = "";
                                int j = 0;
                                while (j < value.length) {
                                    ip = String.valueOf(ip) + (short)(value[j] & 0xFF) + ".";
                                    ++j;
                                }
                                if (ip.endsWith(".")) {
                                    ip = ip.substring(0, ip.length() - 1);
                                }
                                dp.setValue(ip);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                    resList.add(dp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return resList;
    }

    /*
     * Exception decompiling
     */
    public byte[] GetBytes(ParamItem param) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[13] lbl141 : CaseStatement: default:\u000a, @NONE, blocks:[13] lbl141 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

