/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.Command;
import com.jnrsmcu.sdk.netdevice.IData;
import com.jnrsmcu.sdk.netdevice.IDataListener;
import com.jnrsmcu.sdk.netdevice.LoginData;
import com.jnrsmcu.sdk.netdevice.ParamData;
import com.jnrsmcu.sdk.netdevice.ParamIdsData;
import com.jnrsmcu.sdk.netdevice.ParamItem;
import com.jnrsmcu.sdk.netdevice.ParamManager;
import com.jnrsmcu.sdk.netdevice.RealTimeData;
import com.jnrsmcu.sdk.netdevice.Resolver;
import com.jnrsmcu.sdk.netdevice.StoreData;
import com.jnrsmcu.sdk.netdevice.TelecontrolAck;
import com.jnrsmcu.sdk.netdevice.TimmingAck;
import com.jnrsmcu.sdk.netdevice.TransDataAck;
import com.jnrsmcu.sdk.netdevice.WriteParamAck;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RSServer {
    private Collection<IDataListener> dataListeners;
    private static RSServer instance;
    private int port;
    private static Map<Integer, ChannelHandlerContext> deviceChannel;
    ChannelFuture channelFuture = null;
    private boolean isRunning = false;

    static {
        deviceChannel = new HashMap<Integer, ChannelHandlerContext>();
    }

    public void addDataListener(IDataListener listener) {
        if (this.dataListeners == null) {
            this.dataListeners = new HashSet<IDataListener>();
        }
        this.dataListeners.add(listener);
    }

    public void removeDataListener(IDataListener listener) {
        if (this.dataListeners == null) {
            return;
        }
        this.dataListeners.remove(listener);
    }

    private RSServer(int port) {
        this.port = port;
    }

    public static RSServer Initiate(int port) {
        if (instance == null) {
            instance = new RSServer(port);
        }
        return instance;
    }

    public static RSServer Initiate(int port, String paramFilePath) {
        if (instance == null) {
            instance = new RSServer(port);
            ParamManager.getInstance(paramFilePath);
        }
        return instance;
    }

    public void start() throws InterruptedException {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(0);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(1);
        try {
            try {
                ServerBootstrap serverBootstrap = new ServerBootstrap();
                serverBootstrap.group(bossGroup, workerGroup);
                serverBootstrap.channel(NioServerSocketChannel.class);
                serverBootstrap.option(ChannelOption.SO_BACKLOG, 1024);
                serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, true);
                serverBootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

                    @Override
                    public void initChannel(SocketChannel ch) throws Exception {
                        ChannelPipeline p = ch.pipeline();
                        p.addLast(new InboundHandler());
                    }
                });
                this.channelFuture = serverBootstrap.bind(this.port).sync();
                this.channelFuture.channel().closeFuture().sync();
            }
            catch (Exception exception) {
                bossGroup.shutdownGracefully();
                workerGroup.shutdownGracefully();
                deviceChannel.clear();
                this.isRunning = false;
            }
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
            deviceChannel.clear();
            this.isRunning = false;
        }
    }

    public void stop() {
        if (this.isRunning && this.channelFuture != null) {
            this.channelFuture.channel().close();
        }
    }

    public boolean telecontrol(int deviceId, int relayId, int opt, int optTime) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.getTelecontrolData(deviceId, relayId, opt, optTime);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean timming(int deviceId) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.getTimmingData(deviceId);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean callStoreData(int deviceId) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.getCallStoreData(deviceId);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean callParamList(int deviceId) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.CallParamList(deviceId);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean callParam(int deviceId, int paramId) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.CallParam(deviceId, new ArrayList<Short>(paramId));
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean callParam(int deviceId, List<Integer> paramIds) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ArrayList<Short> ids = new ArrayList<Short>();
                for (Integer id : paramIds) {
                    ids.add(id.shortValue());
                }
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.CallParam(deviceId, ids);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean writeParam(int deviceId, List<ParamItem> parameters) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.WriteParam(deviceId, parameters);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean trans(int deviceId, String hexData) {
        try {
            if (deviceChannel.containsKey(deviceId)) {
                ChannelHandlerContext ctx = deviceChannel.get(deviceId);
                byte[] data = Command.Trans(deviceId, hexData);
                ByteBuf bufAck = ctx.alloc().buffer();
                bufAck.writeBytes(data);
                ctx.write(bufAck);
                ctx.flush();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void notifyListeners(IData data, ChannelHandlerContext ctx) {
        for (IDataListener listener : this.dataListeners) {
            switch (data.getClass().getName()) {
                case "com.jnrsmcu.sdk.netdevice.RealTimeData": {
                    listener.receiveRealtimeData((RealTimeData)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.LoginData": {
                    listener.receiveLoginData((LoginData)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.StoreData": {
                    listener.receiveStoreData((StoreData)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.TelecontrolAck": {
                    listener.receiveTelecontrolAck((TelecontrolAck)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.TimmingAck": {
                    listener.receiveTimmingAck((TimmingAck)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.ParamIdsData": {
                    listener.receiveParamIds((ParamIdsData)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.ParamData": {
                    listener.receiveParam((ParamData)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.WriteParamAck": {
                    listener.receiveWriteParamAck((WriteParamAck)data);
                    break;
                }
                case "com.jnrsmcu.sdk.netdevice.TransDataAck": {
                    listener.receiveTransDataAck((TransDataAck)data);
                }
            }
        }
    }

    class InboundHandler
    extends ChannelInboundHandlerAdapter {
        InboundHandler() {
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                byte[] ack;
                ByteBuf buf = (ByteBuf)msg;
                byte[] req = new byte[buf.readableBytes()];
                buf.readBytes(req);
                IData data = Resolver.Convert(req);
                if (data == null) {
                    ctx.close();
                    return;
                }
                if (deviceChannel.containsKey(data.getDeviceId())) {
                    ChannelHandlerContext old = (ChannelHandlerContext)deviceChannel.get(data.getDeviceId());
                    if (old != ctx) {
                        old.close();
                        deviceChannel.put(data.getDeviceId(), ctx);
                    }
                } else {
                    deviceChannel.put(data.getDeviceId(), ctx);
                }
                if ((ack = Command.getAck(data)) != null) {
                    ByteBuf bufAck = ctx.alloc().buffer();
                    bufAck.writeBytes(ack);
                    ctx.write(bufAck);
                    ctx.flush();
                }
                RSServer.this.notifyListeners(data, ctx);
            }
            finally {
                ReferenceCountUtil.release(msg);
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ctx.close();
        }
    }
}

