/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.IData;
import com.jnrsmcu.sdk.netdevice.NodeData;
import com.jnrsmcu.sdk.netdevice.Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class RealTimeData
implements IData {
    private int deviceId;
    private List<NodeData> nodeList = new ArrayList<NodeData>();
    private float lng;
    private float lat;
    private short coordinateType;
    private String relayStatus;

    @Override
    public int getDeviceId() {
        return this.deviceId;
    }

    public List<NodeData> getNodeList() {
        return this.nodeList;
    }

    public float getLng() {
        return this.lng;
    }

    public float getLat() {
        return this.lat;
    }

    public short getCoordinateType() {
        return this.coordinateType;
    }

    public String getRelayStatus() {
        return this.relayStatus;
    }

    protected RealTimeData(byte[] data) {
        byte[] address = new byte[4];
        System.arraycopy(data, data.length - 6, address, 0, address.length);
        this.deviceId = Utils.getIntAddress(address);
        int indexLat = (data[9] & 0xFF) + 10 - 6;
        ByteBuffer lng = ByteBuffer.allocateDirect(4);
        lng = lng.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer lat = ByteBuffer.allocateDirect(4);
        lat = lat.order(ByteOrder.LITTLE_ENDIAN);
        int i = 0;
        while (i < 4) {
            lng.put((byte)(data[indexLat - 10 + i] - 51));
            ++i;
        }
        i = 0;
        while (i < 4) {
            lat.put((byte)(data[indexLat - 6 + i] - 51));
            ++i;
        }
        byte posFlag = (byte)(data[indexLat - 2] - 51);
        this.coordinateType = posFlag;
        lat.rewind();
        lng.rewind();
        if (this.coordinateType == 1 || this.coordinateType == 2) {
            this.lat = lat.getInt();
            this.lng = lng.getInt();
        } else {
            this.lat = lat.getFloat();
            this.lng = lng.getFloat();
        }
        byte relayHigh = (byte)(data[indexLat - 11] - 51);
        byte relayLow = (byte)(data[indexLat - 12] - 51);
        this.relayStatus = this.getRelayStatus(relayLow, relayHigh);
        this.nodeList = this.SplitDataPacket(data);
    }

    private String getRelayStatus(byte btLow, byte btHigh) {
        String low = Integer.toBinaryString((btLow & 0xFF) + 256).substring(1);
        String height = Integer.toBinaryString((btHigh & 0xFF) + 256).substring(1);
        char[] arrLow = low.toCharArray();
        char[] arrHigh = height.toCharArray();
        char[] arrStatus = new char[arrLow.length];
        arrStatus[0] = arrLow[1];
        arrStatus[1] = arrLow[0];
        arrStatus[2] = arrLow[7];
        arrStatus[3] = arrLow[6];
        arrStatus[4] = arrLow[5];
        arrStatus[5] = arrLow[4];
        arrStatus[6] = arrLow[3];
        arrStatus[7] = arrLow[2];
        Utils.reverseChars(arrHigh);
        return String.valueOf(new String(arrStatus)) + new String(arrHigh);
    }

    private List<NodeData> SplitDataPacket(byte[] data) {
        ArrayList<NodeData> _list = new ArrayList<NodeData>();
        int nodeCount = 0;
        if ((data[9] & 0xFF) > 22) {
            nodeCount = ((data[9] & 0xFF) - 22) / 5;
        }
        int i = 0;
        while (i < nodeCount) {
            byte[] nodeData = new byte[5];
            System.arraycopy(data, 12 + i * nodeData.length, nodeData, 0, nodeData.length);
            int idx = 0;
            while (idx < nodeData.length) {
                nodeData[idx] = (byte)(nodeData[idx] - 51);
                ++idx;
            }
            _list.add(new NodeData(nodeData, false));
            ++i;
        }
        return _list;
    }
}

