/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.HeartbeatData;
import com.jnrsmcu.sdk.netdevice.IData;
import com.jnrsmcu.sdk.netdevice.LoginData;
import com.jnrsmcu.sdk.netdevice.ParamData;
import com.jnrsmcu.sdk.netdevice.ParamIdsData;
import com.jnrsmcu.sdk.netdevice.QW;
import com.jnrsmcu.sdk.netdevice.RealTimeData;
import com.jnrsmcu.sdk.netdevice.StoreData;
import com.jnrsmcu.sdk.netdevice.TelecontrolAck;
import com.jnrsmcu.sdk.netdevice.TimmingAck;
import com.jnrsmcu.sdk.netdevice.TransDataAck;
import com.jnrsmcu.sdk.netdevice.Utils;
import com.jnrsmcu.sdk.netdevice.WriteParamAck;

class Resolver {
    Resolver() {
    }

    protected static IData Convert(byte[] data) {
        byte[] bytesMarkCode = new byte[]{(byte)(data[11] - 51), (byte)(data[10] - 51)};
        byte[] bytesAddress = new byte[4];
        System.arraycopy(data, data.length - 6, bytesAddress, 0, bytesAddress.length);
        String strMarkCode = Utils.getHexString(bytesMarkCode);
        switch (strMarkCode.toUpperCase()) {
            case "EA00": {
                return new LoginData(bytesAddress);
            }
            case "EA02": {
                return new HeartbeatData(bytesAddress);
            }
            case "EA03": {
                return new RealTimeData(data);
            }
            case "EA09": 
            case "EA0A": 
            case "EC09": {
                return new StoreData(data, strMarkCode.toUpperCase());
            }
            case "EA0B": {
                return new TimmingAck(data);
            }
            case "EB01": {
                return new TelecontrolAck(data);
            }
            case "8000": {
                return new ParamIdsData(data);
            }
            case "8001": {
                return new ParamData(data);
            }
            case "8002": {
                return new WriteParamAck(data);
            }
            case "8003": {
                return new TransDataAck(data);
            }
            case "EA0C": {
                return new QW(data);
            }
        }
        return null;
    }
}

