/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.IData;
import com.jnrsmcu.sdk.netdevice.NodeData;
import com.jnrsmcu.sdk.netdevice.Utils;
import java.util.ArrayList;
import java.util.List;

public class StoreData
implements IData {
    private int deviceId;
    private List<NodeData> nodeList = new ArrayList<NodeData>();

    @Override
    public int getDeviceId() {
        return this.deviceId;
    }

    public List<NodeData> getNodeList() {
        return this.nodeList;
    }

    protected StoreData(byte[] data, String ctrlCode) {
        byte[] address = new byte[4];
        System.arraycopy(data, data.length - 6, address, 0, address.length);
        this.deviceId = Utils.getIntAddress(address);
        int packageLen = 9;
        if (ctrlCode.equalsIgnoreCase("EC09")) {
            packageLen = 18;
        }
        this.nodeList = this.SplitDataPacket(data, packageLen);
    }

    private List<NodeData> SplitDataPacket(byte[] data, int packageLen) {
        ArrayList<NodeData> _list = new ArrayList<NodeData>();
        int dataCount = (data[12] & 0xFF) - 51;
        int i = 0;
        while (i < dataCount) {
            byte[] nodeData = new byte[packageLen];
            System.arraycopy(data, 13 + i * nodeData.length, nodeData, 0, nodeData.length);
            int idx = 0;
            while (idx < nodeData.length) {
                nodeData[idx] = (byte)(nodeData[idx] - 51);
                ++idx;
            }
            _list.add(new NodeData(nodeData, true));
            ++i;
        }
        return _list;
    }
}

