/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

class Utils {
    Utils() {
    }

    protected static void reverseBytes(byte[] bytes) {
        int start = 0;
        int end = bytes.length - 1;
        while (start < end) {
            byte temp = bytes[end];
            bytes[end] = bytes[start];
            bytes[start] = temp;
            ++start;
            --end;
        }
    }

    protected static void reverseChars(char[] chars) {
        int start = 0;
        int end = chars.length - 1;
        while (start < end) {
            char temp = chars[end];
            chars[end] = chars[start];
            chars[start] = temp;
            ++start;
            --end;
        }
    }

    protected static int getInt(byte[] bytes) {
        return 0xFF & bytes[0] | 0xFF00 & bytes[1] << 8 | 0xFF0000 & bytes[2] << 16 | 0xFF000000 & bytes[3] << 24;
    }

    protected static long getLong(byte[] bytes) {
        return 0xFFL & (long)bytes[0] | 0xFF00L & (long)bytes[1] << 8 | 0xFF0000L & (long)bytes[2] << 16 | 0xFF000000L & (long)bytes[3] << 24 | 0xFF00000000L & (long)bytes[4] << 32 | 0xFF0000000000L & (long)bytes[5] << 40 | 0xFF000000000000L & (long)bytes[6] << 48 | 0xFF00000000000000L & (long)bytes[7] << 56;
    }

    protected static float getFloat(byte[] bytes) {
        return Float.intBitsToFloat(Utils.getInt(bytes));
    }

    protected static float getFloat(byte[] b, int index) {
        int l = b[index + 0];
        l &= 0xFF;
        l = (int)((long)l | (long)b[index + 1] << 8);
        l &= 0xFFFF;
        l = (int)((long)l | (long)b[index + 2] << 16);
        l &= 0xFFFFFF;
        l = (int)((long)l | (long)b[index + 3] << 24);
        return Float.intBitsToFloat(l);
    }

    protected static short getShort(byte[] bytes, int index) {
        return (short)(bytes[index + 1] << 8 | bytes[index + 0] & 0xFF);
    }

    protected static String getHexString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
            ++i;
        }
        return stringBuilder.toString();
    }

    protected static String getHexString(byte[] bytes, String separator) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        int i = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(String.valueOf(hv) + separator);
            ++i;
        }
        return stringBuilder.toString();
    }

    protected static byte[] getBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(Utils.charToByte(hexChars[pos]) << 4 | Utils.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    protected static byte[] getBytes(short s) {
        byte[] b = new byte[2];
        b[1] = (byte)(s >> 8);
        b[0] = (byte)(s >> 0);
        return b;
    }

    protected static byte[] getBytes(float f) {
        int fbit = Float.floatToIntBits(f);
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)(fbit >> 24 - i * 8);
            ++i;
        }
        int len = b.length;
        byte[] dest = new byte[len];
        System.arraycopy(b, 0, dest, 0, len);
        int i2 = 0;
        while (i2 < len / 2) {
            byte temp = dest[i2];
            dest[i2] = dest[len - i2 - 1];
            dest[len - i2 - 1] = temp;
            ++i2;
        }
        return dest;
    }

    protected static byte getByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    protected static int getIntAddress(byte[] address) {
        int i = 0;
        while (i < address.length) {
            address[i] = (byte)(address[i] - 51);
            ++i;
        }
        Utils.reverseBytes(address);
        String strAddr = Utils.getHexString(address);
        return Integer.parseInt(strAddr);
    }

    protected static byte[] getBytesAddress(int address) {
        byte[] bytes = Utils.getBytes(String.valueOf(address));
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)(bytes[i] + 51);
            ++i;
        }
        Utils.reverseBytes(bytes);
        return bytes;
    }

    protected static byte CheckSum(byte[] bytes, int start, int end) {
        byte sum = new Byte(0);
        int j = 0;
        while (j < end) {
            sum = (byte)(sum + bytes[j]);
            ++j;
        }
        return sum;
    }

    protected static byte CheckSum(byte[] bytes, int wSize) {
        byte res = 0;
        int i = 0;
        while (i < wSize) {
            res = (byte)(res + bytes[i]);
            ++i;
        }
        return res;
    }
}

