/*
 * Decompiled with CFR 0.152.
 */
package com.jnrsmcu.sdk.netdevice;

import com.jnrsmcu.sdk.netdevice.IData;
import com.jnrsmcu.sdk.netdevice.ParamItem;
import com.jnrsmcu.sdk.netdevice.ParamManager;
import com.jnrsmcu.sdk.netdevice.Utils;
import java.util.ArrayList;
import java.util.List;

public class WriteParamAck
implements IData {
    private int deviceId;
    private boolean success;
    private int count;
    private List<ParamItem> pararms = new ArrayList<ParamItem>();

    @Override
    public int getDeviceId() {
        return this.deviceId;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getCount() {
        return this.count;
    }

    public List<ParamItem> getPararms() {
        return this.pararms;
    }

    protected WriteParamAck(byte[] data) {
        byte[] address = new byte[4];
        System.arraycopy(data, data.length - 6, address, 0, address.length);
        this.deviceId = Utils.getIntAddress(address);
        short resData = (short)(data[12] - 51 & 0xFF);
        this.success = resData == 1;
        short dataCount = (short)(data[13] - 51 & 0xFF);
        this.count = dataCount;
        int idx = 0;
        int i = 0;
        while (i < this.count) {
            byte[] idBuff = new byte[]{(byte)(data[14 + idx] - 51), (byte)(data[15 + idx] - 51)};
            short id = Utils.getShort(idBuff, 0);
            ParamItem item = ParamManager.getInstance().getPararmItem(id);
            if (item != null) {
                this.pararms.add(item);
            }
            idx += 2;
            ++i;
        }
    }
}

