/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.GPSReader;
import com.entity.FileInfo;
import com.entity.GPSInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GPSDao {
    private static GPSDao instance = new GPSDao();
    private static String rootDir = "E:\\history";

    private GPSDao() {
    }

    public static GPSDao getInstance() {
        return instance;
    }

    public Map<String, Object> queryPage(String callLetter, Timestamp startTime, Timestamp endTime, int startIndex, int count) throws IOException {
        List<FileInfo> list = this.readAll(callLetter, startTime, endTime);
        int countAll = 0;
        for (FileInfo inf : list) {
            countAll = (int)((long)countAll + inf.getAvailableCount());
        }
        List<FileInfo> listPage = this.getSub(list, startIndex, count);
        List<GPSInfo> listGps = this.tranceFile(listPage);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", countAll);
        map.put("list", listGps);
        return map;
    }

    public List<GPSInfo> queryAll(String callLetter, Timestamp startTime, Timestamp endTime) throws IOException {
        List<FileInfo> list = this.readAll(callLetter, startTime, endTime);
        List<GPSInfo> listGps = this.tranceFile(list);
        return listGps;
    }

    private List<GPSInfo> tranceFile(List<FileInfo> list) throws IOException {
        ArrayList<GPSInfo> gpsInfoList = new ArrayList<GPSInfo>();
        for (FileInfo info : list) {
            RandomAccessFile indexF = new RandomAccessFile(info.getIndexFile(), "r");
            RandomAccessFile infoF = new RandomAccessFile(info.getInfoFile(), "r");
            FileChannel indexC = indexF.getChannel();
            FileChannel inforC = infoF.getChannel();
            MappedByteBuffer indexBuff = indexC.map(FileChannel.MapMode.READ_ONLY, 0L, indexF.length());
            MappedByteBuffer infoBuff = inforC.map(FileChannel.MapMode.READ_ONLY, 0L, infoF.length());
            indexBuff.position((int)(info.getStartIndex() * 76L));
            int i = 0;
            while ((long)i < info.getAvailableCount()) {
                GPSInfo gpsInfo = GPSReader.readGPSInfo(indexBuff, infoBuff);
                gpsInfoList.add(gpsInfo);
                ++i;
            }
            inforC.close();
            indexC.close();
            infoF.close();
            indexF.close();
        }
        return gpsInfoList;
    }

    private List<FileInfo> readAll(String callLetter, Timestamp fromTime, Timestamp endTime) throws IOException {
        FileInfo lastFileInfo;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar ts = Calendar.getInstance();
        ts.setTime(fromTime);
        ts.set(11, 0);
        ts.set(12, 0);
        ts.set(13, 0);
        Calendar te = Calendar.getInstance();
        te.setTime(endTime);
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        String callLetterDir = String.valueOf(rootDir) + File.separator + callLetter;
        while (!ts.after(te)) {
            String date = sdf.format(ts.getTime());
            File indexFile = new File(String.valueOf(callLetterDir) + File.separator + date + ".index");
            File infoFile = new File(String.valueOf(callLetterDir) + File.separator + date + ".info");
            if (indexFile.exists() && infoFile.exists()) {
                FileInfo fileInfo = new FileInfo();
                fileInfo.setIndexFile(indexFile);
                fileInfo.setInfoFile(infoFile);
                fileInfo.setDate(date);
                fileInfo.setCount(indexFile.length() / 76L);
                list.add(fileInfo);
            }
            ts.add(5, 1);
        }
        if (list.size() < 1) {
            return list;
        }
        FileInfo firstFileInfo = (FileInfo)list.get(0);
        String searchStartTime = sdf.format(fromTime);
        String searchEndTime = sdf.format(endTime);
        if (searchStartTime.equals(firstFileInfo.getDate())) {
            String dateStart = firstFileInfo.getDate();
            File fileStart = new File(String.valueOf(callLetterDir) + File.separator + dateStart + ".index");
            long k1 = this.searchFirstLPosition(fileStart, fromTime.getTime());
            firstFileInfo.setStartIndex(k1);
        }
        if (searchEndTime.equals((lastFileInfo = (FileInfo)list.get(list.size() - 1)).getDate())) {
            String dateEnd = lastFileInfo.getDate();
            File fileEnd = new File(String.valueOf(callLetterDir) + File.separator + dateEnd + ".index");
            long k2 = this.searchFirstLPosition(fileEnd, endTime.getTime());
            if (k2 != -1L) {
                lastFileInfo.setEndIndex(k2);
            }
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<FileInfo> getSub(List<FileInfo> list, int startIndex, int count) {
        boolean head = false;
        int refStart = startIndex;
        int refCount = count;
        ArrayList<FileInfo> subList = new ArrayList<FileInfo>();
        if (count < 0) {
            return subList;
        }
        int i = 0;
        while (i < list.size()) {
            FileInfo info = list.get(i);
            if (!head) {
                if ((long)refStart >= info.getAvailableCount()) {
                    refStart = (int)((long)refStart - info.getAvailableCount());
                } else {
                    head = true;
                    info.setStartIndex((long)refStart + info.getStartIndex());
                    subList.add(info);
                    if (info.getAvailableCount() >= (long)refCount) {
                        info.setEndIndex((long)refCount + info.getStartIndex() - 1L);
                        return subList;
                    }
                    refCount = (int)((long)refCount - info.getAvailableCount());
                }
            } else {
                subList.add(info);
                if (info.getAvailableCount() >= (long)refCount) {
                    info.setEndIndex((long)refCount - info.getStartIndex() - 1L);
                    return subList;
                }
                refCount = (int)((long)refCount - info.getAvailableCount());
            }
            ++i;
        }
        return subList;
    }

    private long searchFirstLPosition(File file, long time) throws IOException {
        RandomAccessFile rac = null;
        try {
            rac = new RandomAccessFile(file, "r");
            long size = rac.length() / 76L;
            long startIndex = 0L;
            long endIndex = size - 1L;
            if (rac.readLong() >= time) {
                long l = startIndex;
                return l;
            }
            rac.seek(endIndex * 76L);
            if (rac.readLong() < time) {
                return -1L;
            }
            while (true) {
                if (startIndex >= endIndex - 1L) {
                    long l = endIndex;
                    return l;
                }
                long comparenIndex = (startIndex + endIndex) / 2L;
                rac.seek(comparenIndex * 76L);
                long compareValue = rac.readLong();
                if (compareValue >= time) {
                    endIndex = comparenIndex;
                    continue;
                }
                startIndex = comparenIndex;
            }
        }
        finally {
            if (rac != null) {
                rac.close();
            }
        }
    }
}

