/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import SEGGPS.JavaMemCache;
import com.datatype.base.ReceiveInf;
import com.datatype.base.SendInf;
import com.datatype.receive.DataSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MemClient {
    private static Logger logger = Logger.getLogger((String)MemClient.class.getName());
    private int communicateId;
    private String clientName;
    private int clientId;

    public MemClient(String clientName, int clientId) {
        this.clientId = clientId;
        this.clientName = clientName;
    }

    public boolean login(String memIp, short memPort) {
        this.communicateId = JavaMemCache.CreateClient();
        JavaMemCache.SetIDAndName((int)this.communicateId, (String)this.clientName, (int)this.clientId);
        JavaMemCache.SetRemoteIPAndPort((int)this.communicateId, (String)memIp, (short)memPort);
        return JavaMemCache.Logon((int)this.communicateId);
    }

    public void logout() {
        if (this.communicateId != 0) {
            JavaMemCache.Quit((int)this.communicateId);
            JavaMemCache.DestroyClient((int)this.communicateId);
            this.communicateId = 0;
        }
    }

    public boolean sendData(SendInf toSend, String key) {
        logger.debug((Object)("send command:" + toSend.getCommandString()));
        return JavaMemCache.AppendItem((int)this.communicateId, (String)key, (byte[])toSend.getCommandString().getBytes(), (int)toSend.getCommandString().getBytes().length, (int)0);
    }

    public boolean sendData(List<SendInf> toSends, String key) {
        StringBuilder sb = new StringBuilder();
        for (SendInf send : toSends) {
            sb.append(send.getCommandString()).append("|");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        logger.debug((Object)("send data to mem:" + sb.toString()));
        byte[] bts = sb.toString().getBytes();
        return JavaMemCache.AppendItem((int)this.communicateId, (String)key, (byte[])bts, (int)bts.length, (int)0);
    }

    public DataSet receiveData(long fromId, String key, Class<? extends ReceiveInf> c) {
        if (JavaMemCache.GetItemAll((int)this.communicateId, (String)key, (long)fromId)) {
            byte[] byteData = JavaMemCache.GetData((int)this.communicateId);
            long toId = JavaMemCache.GetItemID((int)this.communicateId);
            String strData = new String(byteData);
            logger.debug((Object)("receive data from mem:" + strData));
            String[] packages = strData.split("\\|");
            ArrayList<ReceiveInf> list = new ArrayList<ReceiveInf>();
            String[] stringArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                String pack = stringArray[n2];
                if (pack.indexOf("~") != -1) {
                    ReceiveInf rec;
                    try {
                        rec = c.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("exception when newInstance:" + c.getName());
                    }
                    rec.init(pack);
                    list.add(rec);
                }
                ++n2;
            }
            DataSet info = new DataSet();
            info.setMaxId(toId);
            info.setResponseList(list);
            return info;
        }
        return null;
    }

    public DataSet receiveMultiData(long fromId, String key, List<String> callLetters, Class<? extends ReceiveInf> c) {
        int len;
        StringBuilder multikey = new StringBuilder();
        for (String callLetter : callLetters) {
            multikey.append(key).append(callLetter).append("\u0000");
        }
        byte[] keyBs = multikey.toString().getBytes();
        if (JavaMemCache.GetMultiKeyItemAll((int)this.communicateId, (byte[])keyBs, (int)(len = keyBs.length), (int)callLetters.size(), (long)fromId)) {
            byte[] byteData = JavaMemCache.GetData((int)this.communicateId);
            long toId = JavaMemCache.GetItemID((int)this.communicateId);
            String strData = new String(byteData);
            logger.debug((Object)("receive multi data from mem:" + strData));
            String[] packages = strData.split("\\|");
            ArrayList<ReceiveInf> list = new ArrayList<ReceiveInf>();
            String[] stringArray = packages;
            int n = packages.length;
            int n2 = 0;
            while (n2 < n) {
                String pack = stringArray[n2];
                if (pack.indexOf("~") != -1) {
                    ReceiveInf rec;
                    try {
                        rec = c.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("exception when newInstance:" + c.getName());
                    }
                    rec.init(pack);
                    list.add(rec);
                }
                ++n2;
            }
            DataSet info = new DataSet();
            info.setMaxId(toId);
            info.setResponseList(list);
            return info;
        }
        return null;
    }
}

