/*
 * Decompiled with CFR 0.152.
 */
package com.org.seg.webtool.dao;

import com.org.seg.webtool.dto.DataBaseDTO;
import com.org.seg.webtool.util.db.DBParams;
import com.org.seg.webtool.util.db.DBUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class BaseDao {
    protected static final String GETFLAG = "get";

    protected List<String> listInsertFields(DataBaseDTO dto, DBParams params) {
        Method[] methods;
        ArrayList<String> fields = new ArrayList<String>();
        Method[] methodArray = methods = dto.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith(GETFLAG) && !"getClass".equals(method.getName())) {
                Object value;
                try {
                    value = method.invoke((Object)dto, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                if (value != null) {
                    params.addParam(value);
                    String fieldName = method.getName().substring(GETFLAG.length());
                    fields.add(fieldName);
                }
            }
            ++n2;
        }
        return fields;
    }

    protected boolean containsIgnoreCase(List<String> list, String target) {
        if (list == null || target == null) {
            return false;
        }
        for (String s : list) {
            if (!s.equalsIgnoreCase(target)) continue;
            return true;
        }
        return false;
    }

    protected List<String> listEditFields(DataBaseDTO dto, DBParams params) {
        ArrayList<String> fields = new ArrayList<String>();
        Method[] methods = dto.getClass().getMethods();
        List<String> unEditFields = dto.unEditFields();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName;
            Method method = methodArray[n2];
            if (method.getName().startsWith(GETFLAG) && !"getClass".equals(method.getName()) && !this.containsIgnoreCase(unEditFields, fieldName = method.getName().substring(GETFLAG.length()))) {
                Object value;
                try {
                    value = method.invoke((Object)dto, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                if (value == null) {
                    params.addNullParam(method.getGenericReturnType());
                } else {
                    params.addParam(value);
                }
                fields.add(fieldName);
            }
            ++n2;
        }
        return fields;
    }

    private List<String> listKeyFields(DataBaseDTO dto, DBParams params) {
        ArrayList<String> fields = new ArrayList<String>();
        Method[] methods = dto.getClass().getMethods();
        List<String> keyFields = dto.keyFields();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName;
            Method method = methodArray[n2];
            if (method.getName().startsWith(GETFLAG) && !"getClass".equals(method.getName()) && this.containsIgnoreCase(keyFields, fieldName = method.getName().substring(GETFLAG.length()))) {
                Object value;
                try {
                    value = method.invoke((Object)dto, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("exception when invoke method:" + method.getName());
                }
                params.addParam(value);
                fields.add(fieldName);
            }
            ++n2;
        }
        return fields;
    }

    protected int insert(Connection con, DataBaseDTO dto) {
        int n;
        DBParams params = new DBParams();
        List<String> allFields = this.listInsertFields(dto, params);
        if (allFields.size() < 1) {
            throw new RuntimeException("\u53c2\u6570\u592a\u5c11");
        }
        StringBuilder sql = new StringBuilder();
        StringBuilder sub = new StringBuilder();
        sql.append("insert into ").append(dto.tagetTableName()).append("(");
        for (String field : allFields) {
            sql.append(field.toLowerCase()).append(",");
            sub.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sub.deleteCharAt(sub.length() - 1);
        sql.append(")values(").append((CharSequence)sub).append(")");
        PreparedStatement pst = null;
        try {
            pst = con.prepareStatement(sql.toString());
            params.prepareStatement(pst);
            n = pst.executeUpdate();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closePst(pst);
                throw throwable;
            }
            DBUtil.closePst(pst);
            return -103;
        }
        DBUtil.closePst(pst);
        return n;
    }

    /*
     * Loose catch block
     */
    protected int update(Connection con, DataBaseDTO dto) {
        int n;
        DBParams params = new DBParams();
        List<String> editFields = this.listEditFields(dto, params);
        if (editFields.size() < 1) {
            throw new RuntimeException("\u4fee\u6539\u5b57\u6bb5\u592a\u5c11");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(dto.tagetTableName()).append(" set ");
        for (String field : editFields) {
            sql.append(field.toLowerCase()).append("=?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        List<String> keyFields = this.listKeyFields(dto, params);
        if (keyFields.size() < 1) {
            throw new RuntimeException("key\u5b57\u6bb5\u592a\u5c11");
        }
        sql.append(" where 1=1 ");
        for (String field : keyFields) {
            sql.append(" and ").append(field.toLowerCase()).append("=?");
        }
        PreparedStatement pst = null;
        try {
            pst = con.prepareStatement(sql.toString());
            params.prepareStatement(pst);
            n = pst.executeUpdate();
        }
        catch (SQLException e) {
            DBUtil.closePst(pst);
            return -103;
            catch (Throwable throwable) {
                DBUtil.closePst(pst);
                throw throwable;
            }
        }
        DBUtil.closePst(pst);
        return n;
    }

    /*
     * Loose catch block
     */
    protected int delete(Connection con, DataBaseDTO dto) {
        int n;
        DBParams params = new DBParams();
        List<String> keyFields = this.listKeyFields(dto, params);
        if (keyFields.size() < 1) {
            throw new RuntimeException("key\u5b57\u6bb5\u592a\u5c11");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(dto.tagetTableName()).append(" where 1=1 ");
        for (String field : keyFields) {
            sql.append(" and ").append(field.toLowerCase()).append("=?");
        }
        PreparedStatement pst = null;
        try {
            pst = con.prepareStatement(sql.toString());
            params.prepareStatement(pst);
            n = pst.executeUpdate();
        }
        catch (SQLException e) {
            DBUtil.closePst(pst);
            return -103;
            catch (Throwable throwable) {
                DBUtil.closePst(pst);
                throw throwable;
            }
        }
        DBUtil.closePst(pst);
        return n;
    }
}

