/*
 * Decompiled with CFR 0.152.
 */
package com.org.seg.webtool.util.db;

import com.org.seg.webtool.util.db.ParamEntity;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class DBParams {
    private static final int[] SQLTYPES = new int[]{4, -5, 12, 91, 93, 8, 92};
    private static final Class<?>[] CLASSTYPES = new Class[]{Integer.class, Long.class, String.class, Date.class, Timestamp.class, Double.class, Time.class};
    private List<ParamEntity> paramList = new ArrayList<ParamEntity>();

    public DBParams copy() {
        DBParams copy = new DBParams();
        for (ParamEntity entity : this.paramList) {
            copy.paramList.add(entity);
        }
        return copy;
    }

    public void addParam(Object o) {
        this.addParam(o, this.getSqlTypeByClassType(o.getClass()));
    }

    private int getSqlTypeByClassType(Type type) {
        int i = 0;
        while (i < CLASSTYPES.length) {
            if (type == CLASSTYPES[i]) {
                return SQLTYPES[i];
            }
            ++i;
        }
        throw new RuntimeException("unSupport Type type:" + type);
    }

    private int checkSupportType(int sqlType) {
        int i = 0;
        while (i < SQLTYPES.length) {
            if (sqlType == SQLTYPES[i]) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("unsurpport sqltype:" + sqlType);
    }

    public void addNullParam(int sqlType) {
        this.checkSupportType(sqlType);
        this.addParam(null, sqlType);
    }

    public void addNullParam(Type t) {
        this.addParam(null, this.getSqlTypeByClassType(t));
    }

    private void addParam(Object o, int type) {
        ParamEntity entity = new ParamEntity(o, type);
        this.paramList.add(entity);
    }

    public void prepareStatement(PreparedStatement pst, int startIndex) throws SQLException {
        for (ParamEntity e : this.paramList) {
            int v = e.getValueType();
            Object o = e.getValue();
            if (o == null) {
                pst.setNull(startIndex++, v);
                continue;
            }
            if (v == SQLTYPES[0]) {
                pst.setInt(startIndex++, (Integer)o);
                continue;
            }
            if (v == SQLTYPES[1]) {
                pst.setLong(startIndex++, (Long)o);
                continue;
            }
            if (v == SQLTYPES[2]) {
                pst.setString(startIndex++, (String)o);
                continue;
            }
            if (v == SQLTYPES[3]) {
                pst.setDate(startIndex++, (Date)o);
                continue;
            }
            if (v == SQLTYPES[4]) {
                pst.setTimestamp(startIndex++, (Timestamp)o);
                continue;
            }
            if (v == SQLTYPES[5]) {
                pst.setDouble(startIndex++, (Double)o);
                continue;
            }
            if (v != SQLTYPES[6]) continue;
            pst.setTime(startIndex++, (Time)o);
        }
    }

    public void prepareStatement(PreparedStatement pst) throws SQLException {
        this.prepareStatement(pst, 1);
    }
}

