/*
 * Decompiled with CFR 0.152.
 */
package com.org.seg.webtool.util.db;

import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class DTOUtil {
    private static final String SETFLAG = "set";
    private static final int ARRAY_TYPE_VECTOR = 1;
    private static final int ARRAY_TYPE_LIST = 2;
    private static final int ARRAY_TYPE_ARRAYLIST = 3;

    public static Object initFromRequest(HttpServletRequest request, Object dto) {
        Method[] methods;
        Method[] methodArray = methods = dto.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith(SETFLAG)) {
                Object fieldValue;
                String fieldName = method.getName().substring(SETFLAG.length());
                fieldName = fieldName.replaceFirst(fieldName.substring(0, 1), fieldName.substring(0, 1).toLowerCase());
                if (DTOUtil.isArrayField(method)) {
                    fieldValue = request.getParameterValues(fieldName);
                    if (fieldValue == null || !DTOUtil.checkArrayField(fieldValue)) {
                        System.err.println("null value when initFromRequest,fieldName:" + fieldName + " fieldValue:" + fieldValue);
                    } else {
                        DTOUtil.initArrayField(dto, method, fieldValue);
                    }
                } else {
                    fieldValue = request.getParameter(fieldName);
                    if (fieldValue == null) {
                        System.err.println("null value when initFromRequest,fieldName:" + fieldName + " fieldValue:" + (String)fieldValue);
                    } else {
                        DTOUtil.initField(dto, method, (String)fieldValue);
                    }
                }
            }
            ++n2;
        }
        return dto;
    }

    public static Object initFromRequest(HttpServletRequest request, Class<?> dtoClass) {
        Object dto;
        try {
            dto = dtoClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("exception when newInstance:" + dtoClass.getName());
        }
        DTOUtil.initFromRequest(request, dto);
        return dto;
    }

    private static boolean checkArrayField(String[] fieldValue) {
        return fieldValue.length != 1 || fieldValue[0].trim().length() != 0;
    }

    private static void initField(Object o, Method method, String fieldValue) {
        block10: {
            Class<?> pType = method.getParameterTypes()[0];
            try {
                if (pType.equals(Integer.TYPE) || pType.equals(Integer.class)) {
                    method.invoke(o, Integer.parseInt(fieldValue));
                    break block10;
                }
                if (pType.equals(Float.TYPE) || pType.equals(Float.class)) {
                    method.invoke(o, Float.valueOf(Float.parseFloat(fieldValue)));
                    break block10;
                }
                if (pType.equals(Double.TYPE) || pType.equals(Double.class)) {
                    method.invoke(o, Double.parseDouble(fieldValue));
                    break block10;
                }
                if (pType.equals(Long.TYPE) || pType.equals(Long.class)) {
                    method.invoke(o, Long.parseLong(fieldValue));
                    break block10;
                }
                if (pType.equals(String.class)) {
                    method.invoke(o, fieldValue);
                    break block10;
                }
                if (pType.equals(Timestamp.class)) {
                    method.invoke(o, Timestamp.valueOf(fieldValue));
                    break block10;
                }
                if (pType.equals(Date.class)) {
                    method.invoke(o, Date.valueOf(fieldValue));
                    break block10;
                }
                if (pType.equals(Time.class)) {
                    method.invoke(o, Time.valueOf(fieldValue));
                    break block10;
                }
                throw new RuntimeException("unsupport type exception when initField, method is:" + method.getName());
            }
            catch (Exception e) {
                System.err.println("exception when initFromRequest,method is:" + method.getName() + " fieldValue:" + fieldValue);
            }
        }
    }

    private static boolean isArrayField(Method m) {
        if (m.getParameterTypes().length < 1) {
            return false;
        }
        Class<?> p0 = m.getParameterTypes()[0];
        return p0.isArray() || Collection.class.isAssignableFrom(p0);
    }

    private static void initArrayField(Object obj, Method m, String[] fieldValue) {
        Class<?> p0 = m.getParameterTypes()[0];
        try {
            if (p0.isArray()) {
                m.invoke(obj, DTOUtil.getArray(p0.getComponentType(), fieldValue));
            } else if (Collection.class.isAssignableFrom(p0)) {
                String innerType = DTOUtil.getInnerType(m.getGenericParameterTypes()[0].toString());
                if (Vector.class.isAssignableFrom(p0)) {
                    m.invoke(obj, DTOUtil.getArray(innerType, fieldValue, 1));
                } else if (ArrayList.class.isAssignableFrom(p0)) {
                    m.invoke(obj, DTOUtil.getArray(innerType, fieldValue, 3));
                } else if (List.class.isAssignableFrom(p0)) {
                    m.invoke(obj, DTOUtil.getArray(innerType, fieldValue, 2));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("exception when init arrayField, method is:" + m.getName());
        }
    }

    private static Object getArray(Class<?> componentType, String[] fieldValue) {
        if (componentType.equals(Integer.TYPE) || componentType.equals(Integer.class)) {
            int[] a = new int[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Integer.parseInt(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(Short.TYPE) || componentType.equals(Short.class)) {
            short[] a = new short[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Short.parseShort(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(Float.TYPE) || componentType.equals(Float.class)) {
            float[] a = new float[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Float.parseFloat(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(Double.TYPE) || componentType.equals(Double.class)) {
            double[] a = new double[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Double.parseDouble(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(Long.TYPE) || componentType.equals(Long.class)) {
            long[] a = new long[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Long.parseLong(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(String.class)) {
            String[] a = new String[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = fieldValue[i];
                ++i;
            }
            return a;
        }
        if (componentType.equals(Timestamp.class)) {
            Timestamp[] a = new Timestamp[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Timestamp.valueOf(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(Date.class)) {
            Date[] a = new Date[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Date.valueOf(fieldValue[i]);
                ++i;
            }
            return a;
        }
        if (componentType.equals(Time.class)) {
            Time[] a = new Time[fieldValue.length];
            int i = 0;
            while (i < fieldValue.length) {
                a[i] = Time.valueOf(fieldValue[i]);
                ++i;
            }
            return a;
        }
        throw new RuntimeException("unsupport type exception when get array, type:" + componentType);
    }

    private static Object getArray(String innerType, String[] fieldValue, int arrayType) {
        if (innerType == null) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                l.add(value);
                ++n2;
            }
            return l;
        }
        if (innerType.equals("java.lang.Short")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n3 = 0;
            while (n3 < n) {
                String value = stringArray[n3];
                l.add(Short.parseShort(value));
                ++n3;
            }
            return l;
        }
        if (innerType.equals("java.lang.Integer")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n4 = 0;
            while (n4 < n) {
                String value = stringArray[n4];
                l.add(Integer.parseInt(value));
                ++n4;
            }
            return l;
        }
        if (innerType.equals("java.lang.Float")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n5 = 0;
            while (n5 < n) {
                String value = stringArray[n5];
                l.add(Float.valueOf(Float.parseFloat(value)));
                ++n5;
            }
            return l;
        }
        if (innerType.equals("java.lang.Double")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n6 = 0;
            while (n6 < n) {
                String value = stringArray[n6];
                l.add(Double.parseDouble(value));
                ++n6;
            }
            return l;
        }
        if (innerType.equals("java.lang.Long")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n7 = 0;
            while (n7 < n) {
                String value = stringArray[n7];
                l.add(Long.parseLong(value));
                ++n7;
            }
            return l;
        }
        if (innerType.equals("java.lang.String")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n8 = 0;
            while (n8 < n) {
                String value = stringArray[n8];
                l.add(value);
                ++n8;
            }
            return l;
        }
        if (innerType.equals("java.sql.Timestamp")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n9 = 0;
            while (n9 < n) {
                String value = stringArray[n9];
                l.add(Timestamp.valueOf(value));
                ++n9;
            }
            return l;
        }
        if (innerType.equals("java.sql.Date")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n10 = 0;
            while (n10 < n) {
                String value = stringArray[n10];
                l.add(Date.valueOf(value));
                ++n10;
            }
            return l;
        }
        if (innerType.equals("java.sql.Time")) {
            AbstractList l = arrayType == 1 ? new Vector() : new ArrayList();
            String[] stringArray = fieldValue;
            int n = fieldValue.length;
            int n11 = 0;
            while (n11 < n) {
                String value = stringArray[n11];
                l.add(Time.valueOf(value));
                ++n11;
            }
            return l;
        }
        throw new RuntimeException("unsupport type exception when get list, type:" + innerType);
    }

    private static String getInnerType(String gp) {
        int startIndex = gp.indexOf("<");
        int endIndex = gp.indexOf(">");
        if (startIndex == -1 || endIndex == -1 || startIndex >= endIndex) {
            return null;
        }
        return gp.substring(startIndex + 1, endIndex);
    }
}

