/*
 * Decompiled with CFR 0.152.
 */
package com.spring4all.spring.boot.starter.hbase.api;

import com.spring4all.spring.boot.starter.hbase.api.HBaseOperations;
import com.spring4all.spring.boot.starter.hbase.api.HBaseSystemException;
import com.spring4all.spring.boot.starter.hbase.api.MutatorCallback;
import com.spring4all.spring.boot.starter.hbase.api.RowMapper;
import com.spring4all.spring.boot.starter.hbase.api.TableCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public class HBaseTemplate
implements HBaseOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseTemplate.class);
    private Configuration configuration;
    private volatile Connection connection;

    public HBaseTemplate(Configuration configuration) {
        this.setConfiguration(configuration);
        Assert.notNull((Object)configuration, (String)" a valid configuration is required");
    }

    @Override
    public <T> T execute(String tableName, TableCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        Assert.notNull((Object)tableName, (String)"No table specified");
        StopWatch sw = new StopWatch();
        sw.start();
        Table table = null;
        try {
            table = this.getConnection().getTable(TableName.valueOf((String)tableName));
            T t = action.doInTable(table);
            return t;
        }
        catch (Throwable throwable) {
            throw new HBaseSystemException(throwable);
        }
        finally {
            if (null != table) {
                try {
                    table.close();
                    sw.stop();
                }
                catch (IOException e) {
                    LOGGER.error("hbase\u8d44\u6e90\u91ca\u653e\u5931\u8d25");
                }
            }
        }
    }

    @Override
    public <T> List<T> find(String tableName, String family, RowMapper<T> action) {
        Scan scan = new Scan();
        scan.setCaching(5000);
        scan.addFamily(Bytes.toBytes((String)family));
        return this.find(tableName, scan, action);
    }

    @Override
    public <T> List<T> find(String tableName, String family, String qualifier, RowMapper<T> action) {
        Scan scan = new Scan();
        scan.setCaching(5000);
        scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
        return this.find(tableName, scan, action);
    }

    @Override
    public <T> List<T> find(String tableName, final Scan scan, final RowMapper<T> action) {
        return (List)this.execute(tableName, new TableCallback<List<T>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<T> doInTable(Table table) throws Throwable {
                int caching = scan.getCaching();
                if (caching == 1) {
                    scan.setCaching(5000);
                }
                try (ResultScanner scanner = table.getScanner(scan);){
                    ArrayList rs = new ArrayList();
                    int rowNum = 0;
                    for (Result result : scanner) {
                        rs.add(action.mapRow(result, rowNum++));
                    }
                    ArrayList arrayList = rs;
                    return arrayList;
                }
            }
        });
    }

    @Override
    public <T> T get(String tableName, String rowName, RowMapper<T> mapper) {
        return this.get(tableName, rowName, null, null, mapper);
    }

    @Override
    public <T> T get(String tableName, String rowName, String familyName, RowMapper<T> mapper) {
        return this.get(tableName, rowName, familyName, null, mapper);
    }

    @Override
    public <T> T get(String tableName, final String rowName, final String familyName, final String qualifier, final RowMapper<T> mapper) {
        return this.execute(tableName, new TableCallback<T>(){

            @Override
            public T doInTable(Table table) throws Throwable {
                Get get = new Get(Bytes.toBytes((String)rowName));
                if (StringUtils.isNotBlank((String)familyName)) {
                    byte[] family = Bytes.toBytes((String)familyName);
                    if (StringUtils.isNotBlank((String)qualifier)) {
                        get.addColumn(family, Bytes.toBytes((String)qualifier));
                    } else {
                        get.addFamily(family);
                    }
                }
                Result result = table.get(get);
                return mapper.mapRow(result, 0);
            }
        });
    }

    @Override
    public void execute(String tableName, MutatorCallback action) {
        Assert.notNull((Object)action, (String)"Callback object must not be null");
        Assert.notNull((Object)tableName, (String)"No table specified");
        StopWatch sw = new StopWatch();
        sw.start();
        BufferedMutator mutator = null;
        try {
            BufferedMutatorParams mutatorParams = new BufferedMutatorParams(TableName.valueOf((String)tableName));
            mutator = this.getConnection().getBufferedMutator(mutatorParams.writeBufferSize(0x300000L));
            action.doInMutator(mutator);
        }
        catch (Throwable throwable) {
            sw.stop();
            throw new HBaseSystemException(throwable);
        }
        finally {
            if (null != mutator) {
                try {
                    mutator.flush();
                    mutator.close();
                    sw.stop();
                }
                catch (IOException e) {
                    LOGGER.error("hbase mutator\u8d44\u6e90\u91ca\u653e\u5931\u8d25");
                }
            }
        }
    }

    @Override
    public void saveOrUpdate(String tableName, final Mutation mutation) {
        this.execute(tableName, new MutatorCallback(){

            @Override
            public void doInMutator(BufferedMutator mutator) throws Throwable {
                mutator.mutate(mutation);
            }
        });
    }

    @Override
    public void saveOrUpdates(String tableName, final List<Mutation> mutations) {
        this.execute(tableName, new MutatorCallback(){

            @Override
            public void doInMutator(BufferedMutator mutator) throws Throwable {
                mutator.mutate(mutations);
            }
        });
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() {
        if (null == this.connection) {
            HBaseTemplate hBaseTemplate = this;
            synchronized (hBaseTemplate) {
                if (null == this.connection) {
                    try {
                        ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(200, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
                        poolExecutor.prestartCoreThread();
                        this.connection = ConnectionFactory.createConnection((Configuration)this.configuration, (ExecutorService)poolExecutor);
                    }
                    catch (IOException e) {
                        LOGGER.error("hbase connection\u8d44\u6e90\u6c60\u521b\u5efa\u5931\u8d25");
                    }
                }
            }
        }
        return this.connection;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

