/*
 * Decompiled with CFR 0.152.
 */
package com.szzhaona.memcacheclient;

import java.util.Date;

public class ByteUtil {
    @Deprecated
    public static byte[] encode(Byte value) {
        byte[] b = new byte[]{value};
        return b;
    }

    public static byte[] encode(Boolean value) {
        byte[] b = new byte[]{value != false ? (byte)1 : 0};
        return b;
    }

    public static byte[] encodeIntegerToHost(int value) {
        return ByteUtil.encodeIntegerToLittleEndian(value);
    }

    public static byte[] encodeIntegerToLittleEndian(int value) {
        byte[] b = new byte[]{(byte)(value >> 0 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return b;
    }

    public static byte[] encodeIntegerToNetwork(int value) {
        return ByteUtil.encodeIntegerToBigEndian(value);
    }

    public static byte[] encodeIntegerToBigEndian(int value) {
        byte[] b = new byte[4];
        b[3] = (byte)(value >> 0 & 0xFF);
        b[2] = (byte)(value >> 8 & 0xFF);
        b[1] = (byte)(value >> 16 & 0xFF);
        b[0] = (byte)(value >> 24 & 0xFF);
        return b;
    }

    public static byte[] encodeLongToHost(long value) {
        return ByteUtil.encodeLongToLittleEndian(value);
    }

    public static byte[] encodeLongToNetwork(long value) {
        return ByteUtil.encodeLongToBigEndian(value);
    }

    public static byte[] encodeLongToLittleEndian(long value) {
        byte[] b = new byte[]{(byte)(value >> 0 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 56 & 0xFFL)};
        return b;
    }

    public static byte[] encodeLongToBigEndian(long value) {
        byte[] b = new byte[8];
        b[7] = (byte)(value >> 0 & 0xFFL);
        b[6] = (byte)(value >> 8 & 0xFFL);
        b[5] = (byte)(value >> 16 & 0xFFL);
        b[4] = (byte)(value >> 24 & 0xFFL);
        b[3] = (byte)(value >> 32 & 0xFFL);
        b[2] = (byte)(value >> 40 & 0xFFL);
        b[1] = (byte)(value >> 48 & 0xFFL);
        b[0] = (byte)(value >> 56 & 0xFFL);
        return b;
    }

    public static byte[] encode(Date value) {
        return ByteUtil.getBytes(value.getTime());
    }

    public static byte[] encode(String value) throws Exception {
        return value.getBytes("gbk");
    }

    public static byte[] encode(StringBuffer value) throws Exception {
        return ByteUtil.encode(value.toString());
    }

    public static byte[] encodeFloat(float value) throws Exception {
        return ByteUtil.encodeIntegerToHost(Float.floatToIntBits(value));
    }

    public static byte[] encodeShortToHost(short value) {
        return ByteUtil.encodeShortToLittleEndian(value);
    }

    public static byte[] encodeShortToNetwork(short value) {
        return ByteUtil.encodeShortToBigEndian(value);
    }

    public static byte[] encodeShortToLittleEndian(short value) {
        byte[] b = new byte[]{(byte)(value >> 0 & 0xFF), (byte)(value >> 8 & 0xFF)};
        return b;
    }

    public static byte[] encodeShortToBigEndian(short value) {
        byte[] b = new byte[2];
        b[1] = (byte)(value >> 0 & 0xFF);
        b[0] = (byte)(value >> 8 & 0xFF);
        return b;
    }

    public static byte[] encodeDouble(double value) throws Exception {
        return ByteUtil.encodeLongToHost(Double.doubleToLongBits(value));
    }

    public static byte[] encode(StringBuilder value) throws Exception {
        return ByteUtil.encode(value.toString());
    }

    @Deprecated
    public static byte[] encode(byte[] value) {
        return value;
    }

    @Deprecated
    public static byte[] getBytes(long value) {
        byte[] b = new byte[8];
        b[7] = (byte)(value >> 0 & 0xFFL);
        b[6] = (byte)(value >> 8 & 0xFFL);
        b[5] = (byte)(value >> 16 & 0xFFL);
        b[4] = (byte)(value >> 24 & 0xFFL);
        b[3] = (byte)(value >> 32 & 0xFFL);
        b[2] = (byte)(value >> 40 & 0xFFL);
        b[1] = (byte)(value >> 48 & 0xFFL);
        b[0] = (byte)(value >> 56 & 0xFFL);
        return b;
    }

    @Deprecated
    public static byte[] getBytes(int value) {
        byte[] b = new byte[]{(byte)(value >> 0 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        return b;
    }

    @Deprecated
    public static Byte decodeByte(byte[] b) {
        return new Byte(b[0]);
    }

    public static boolean decodeBoolean(byte[] b) {
        return ByteUtil.decodeBoolean(b, 0);
    }

    public static boolean decodeBoolean(byte[] b, int off) {
        return b[off] == 1;
    }

    public static int decodeIntegerFromHost(byte[] b) {
        return ByteUtil.decodeIntegerFromLittleEndian(b, 0);
    }

    public static int decodeIntegerFromHost(byte[] b, int off) {
        return ByteUtil.decodeIntegerFromLittleEndian(b, off);
    }

    public static int decodeIntegerFromLittleEndian(byte[] b, int off) {
        return (b[off + 0] & 0xFF) + ((b[off + 1] & 0xFF) << 8) + ((b[off + 2] & 0xFF) << 16) + ((b[off + 3] & 0xFF) << 24);
    }

    public static int decodeIntegerFromNetwork(byte[] b) {
        return ByteUtil.decodeIntegerFromBigEndian(b, 0);
    }

    public static int decodeIntegerFromNetwork(byte[] b, int off) {
        return ByteUtil.decodeIntegerFromBigEndian(b, off);
    }

    public static int decodeIntegerFromBigEndian(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static long decodeLongFromHost(byte[] b) {
        return ByteUtil.decodeLongFromLittleEndian(b, 0);
    }

    public static long decodeLongFromHost(byte[] b, int off) {
        return ByteUtil.decodeLongFromLittleEndian(b, off);
    }

    public static long decodeLongFromLittleEndian(byte[] b, int off) {
        return ((long)(b[off + 7] & 0xFF) << 56) + ((long)(b[off + 6] & 0xFF) << 48) + ((long)(b[off + 5] & 0xFF) << 40) + ((long)(b[off + 4] & 0xFF) << 32) + ((long)(b[off + 3] & 0xFF) << 24) + ((long)(b[off + 2] & 0xFF) << 16) + ((long)(b[off + 1] & 0xFF) << 8) + (long)(b[off + 0] & 0xFF);
    }

    public static long decodeLongFromNetwork(byte[] b) {
        return ByteUtil.decodeLongFromBigEndian(b, 0);
    }

    public static long decodeLongFromNetwork(byte[] b, int off) {
        return ByteUtil.decodeLongFromBigEndian(b, off);
    }

    public static long decodeLongFromBigEndian(byte[] b, int off) {
        return ((long)(b[off + 0] & 0xFF) << 56) + ((long)(b[off + 1] & 0xFF) << 48) + ((long)(b[off + 2] & 0xFF) << 40) + ((long)(b[off + 3] & 0xFF) << 32) + ((long)(b[off + 4] & 0xFF) << 24) + ((long)(b[off + 5] & 0xFF) << 16) + ((long)(b[off + 6] & 0xFF) << 8) + (long)(b[off + 7] & 0xFF);
    }

    public static String decodeString(byte[] b) throws Exception {
        return new String(b, "gbk");
    }

    public static String decodeString(byte[] b, int off, int length) throws Exception {
        return new String(b, off, length, "gbk");
    }

    public static float decodeFloat(byte[] b) {
        return ByteUtil.decodeFloat(b, 0);
    }

    public static float decodeFloat(byte[] b, int off) {
        int i = ByteUtil.decodeIntegerFromHost(b, off);
        return Float.intBitsToFloat(i);
    }

    public static short decodeShortFromHost(byte[] b) {
        return ByteUtil.decodeShortFromLittleEndian(b, 0);
    }

    public static short decodeShortFromHost(byte[] b, int off) {
        return ByteUtil.decodeShortFromLittleEndian(b, off);
    }

    public static short decodeShortFromLittleEndian(byte[] b, int off) {
        return (short)((b[off + 0] & 0xFF) + ((b[off + 1] & 0xFF) << 8));
    }

    public static short decodeShortFromNetwork(byte[] b) {
        return ByteUtil.decodeShortFromBigEndian(b, 0);
    }

    public static short decodeShortFromNetwork(byte[] b, int off) {
        return ByteUtil.decodeShortFromBigEndian(b, off);
    }

    public static short decodeShortFromBigEndian(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + ((b[off + 0] & 0xFF) << 8));
    }

    public static double decodeDouble(byte[] b, int off) {
        long l = ByteUtil.decodeLongFromHost(b, off);
        return Double.longBitsToDouble(l);
    }

    public static double decodeDouble(byte[] b) {
        return ByteUtil.decodeDouble(b, 0);
    }

    @Deprecated
    public static Date decodeDate(byte[] b) {
        return new Date(ByteUtil.toLong(b));
    }

    @Deprecated
    public static StringBuilder decodeStringBuilder(byte[] b) throws Exception {
        return new StringBuilder(ByteUtil.decodeString(b));
    }

    @Deprecated
    public static byte[] decodeByteArr(byte[] b) {
        return b;
    }

    @Deprecated
    public static int toInt(byte[] b) {
        return ((b[3] & 0xFF) << 56) + ((b[2] & 0xFF) << 48) + ((b[1] & 0xFF) << 40) + ((b[0] & 0xFF) << 32);
    }

    @Deprecated
    public static long toLong(byte[] b) {
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + ((long)b[7] & 0xFFL);
    }

    public static void main(String[] args) {
        byte[] b = new byte[]{2, 1};
        int off = 0;
        System.out.println(b[off + 0] & 0xFF);
        System.out.println((b[off + 1] & 0xFF) << 8);
        System.out.println((b[off + 0] & 0xFF) + ((b[off + 1] & 0xFF) << 8));
        int i = 0x8000000;
        long l = 0x800000000000000L;
        System.out.println(i);
        System.out.println(l);
    }
}

