/*
 * Decompiled with CFR 0.152.
 */
package com.szzhaona.memcacheclient;

import com.szzhaona.memcacheclient.SocketIO;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class JavaMemCache {
    private static Logger log = Logger.getLogger((String)SocketIO.class.getName());
    private static Map<Object, SocketIO> pool = new HashMap<Object, SocketIO>();

    public static synchronized long createClient() {
        long clientID = new Date().getTime();
        SocketIO socketIO = new SocketIO();
        pool.put(clientID, socketIO);
        return clientID;
    }

    public static boolean setIDAndName(long nClientID, String strName, int nID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        socketIO.setStrName(strName);
        socketIO.setNID(nID);
        return true;
    }

    public static boolean setRemoteIPAndPort(long nClientID, String strIP, int nPort) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        socketIO.setStrIP(strIP);
        socketIO.setNPort(nPort);
        return true;
    }

    public static boolean setTimeOut(long nClientID, int connectTimeout, int timeout) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        socketIO.setConnectTimeout(connectTimeout);
        socketIO.setTimeout(timeout);
        return true;
    }

    public static boolean init(long nClientID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        try {
            socketIO.init();
            return true;
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316Socket\u5931\u8d25!");
            e.printStackTrace();
            return false;
        }
    }

    public static boolean logon(long nClientID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        try {
            socketIO.logon();
            return socketIO.isLogonFlag();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean destroyClient(long nClientID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        try {
            socketIO.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean destroy() {
        Iterator<Object> iter = pool.keySet().iterator();
        SocketIO socketIO = null;
        long nClientID = 0L;
        boolean rtnFlag = true;
        while (iter.hasNext()) {
            nClientID = (Long)iter.next();
            socketIO = pool.get(nClientID);
            try {
                socketIO.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                rtnFlag = false;
                break;
            }
        }
        return rtnFlag;
    }

    public static boolean quit(long nClientID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return false;
        }
        try {
            socketIO.quit();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean add(long nClientID, String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.add(strKey, pData, nDataLen, nExptime);
    }

    public static boolean replace(long nClientID, String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.replace(strKey, pData, nDataLen, nExptime);
    }

    public static boolean set(long nClientID, String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.set(strKey, pData, nDataLen, nExptime);
    }

    public static boolean appendItem(long nClientID, String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.appendItem(strKey, pData, nDataLen, nExptime);
    }

    public static boolean delete(long nClientID, String strKey) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.delete(strKey);
    }

    public static boolean flushAll(long nClientID) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.flushAll();
    }

    public static boolean get(long nClientID, String strKey) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.get(strKey);
    }

    public static boolean getAndDelete(long nClientID, String strKey) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.getAndDelete(strKey);
    }

    public static boolean getItem(long nClientID, String strKey, long nMinItemID) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.getItem(strKey, nMinItemID);
    }

    public static boolean getItemAndDelete(long nClientID, String strKey, long nMinItemID) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.getItemAndDelete(strKey, nMinItemID);
    }

    public static boolean getItemAll(long nClientID, String strKey, long nMinItemID) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.getItemAll(strKey, nMinItemID);
    }

    public static boolean getItemAllAndDelete(long nClientID, String strKey, long nMinItemID) throws Exception {
        SocketIO socketIO;
        block4: {
            socketIO = pool.get(nClientID);
            if (socketIO == null) {
                throw new Exception("\u65e0\u6548\u7684\u53e5\u67c4nClientID\uff1a" + nClientID);
            }
            if (socketIO.isLogonFlag()) break block4;
            return false;
        }
        return socketIO.getItemAllAndDelete(strKey, nMinItemID);
    }

    public static byte[] getData(long nClientID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return null;
        }
        return socketIO.getData();
    }

    public static long getItemID(long nClientID) {
        SocketIO socketIO = pool.get(nClientID);
        if (socketIO == null) {
            return 0L;
        }
        return socketIO.getItemID();
    }
}

