/*
 * Decompiled with CFR 0.152.
 */
package com.szzhaona.memcacheclient;

import com.szzhaona.memcacheclient.ByteUtil;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Logger;

public class SocketIO {
    private static Logger log = Logger.getLogger(SocketIO.class);
    private static final int EXP_TIME = 0;
    private String strName;
    private int nID;
    private String strIP;
    private int nPort;
    private int timeout;
    private int connectTimeout;
    private Socket sock;
    private DataInputStream in;
    private BufferedOutputStream out;
    private boolean logonFlag = false;
    private long itemID;
    private byte[] data;

    public synchronized void init() throws IOException {
        log.debug((Object)"\u521d\u59cb\u5316Socket!");
        this.sock = this.getSocket(this.strIP, this.nPort, this.connectTimeout);
        if (this.timeout >= 0) {
            this.sock.setSoTimeout(this.timeout);
        }
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new BufferedOutputStream(this.sock.getOutputStream());
        log.debug((Object)"\u521d\u59cb\u5316Socket\u6210\u529f!");
    }

    private Socket getSocket(String host, int port, int connectTimeout) throws IOException {
        SocketChannel sock = SocketChannel.open();
        sock.socket().connect(new InetSocketAddress(host, port), connectTimeout);
        return sock.socket();
    }

    public synchronized void close() throws Exception {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.close();
        }
        if (this.sock != null) {
            this.sock.close();
        }
        this.in = null;
        this.out = null;
        this.sock = null;
    }

    public static void show(byte[] bs) {
        int i = 0;
        while (i < bs.length) {
            System.out.print(bs[i]);
            System.out.print(" ");
            ++i;
        }
        System.out.println();
    }

    public synchronized void logon() throws Exception {
        byte[] b2;
        log.debug((Object)("\u4f7f\u7528ID\uff08" + this.nID + "\uff09\u548c\u540d\u5b57\uff08" + this.strName + "\uff09\u767b\u5f55Socket\u670d\u52a1\u5668!"));
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(this.strName).length;
        int len2 = 12 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 1;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(this.nID), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(this.strName), 0, b, off += 4, len);
        b[off += len] = 0;
        this.out.write(b);
        this.out.flush();
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 1 && b2[3] == 0) {
                this.logonFlag = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"\u767b\u5f55\u9a8c\u8bc1\u6210\u529f\uff01");
                break;
            }
            if (b2[2] != 1 || b2[3] == 0) continue;
            this.logonFlag = false;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)"\u767b\u5f55\u9a8c\u8bc1\u5931\u8d25\uff01");
            break;
        }
    }

    public synchronized void quit() throws Exception {
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(this.strName).length;
        int len2 = 12 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 2;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(this.nID), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(this.strName), 0, b, off += 4, len);
        b[off += len] = 0;
        this.out.write(b);
        this.out.flush();
    }

    public synchronized void resetConnectAndLogon() throws Exception {
        this.init();
        this.logon();
    }

    public synchronized void resetTimeout() throws Exception {
        this.sock.setSoTimeout(this.timeout);
    }

    public synchronized boolean add(String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1 + pData.length;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 17;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nExptime), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nDataLen), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, len);
        off += len;
        b[off++] = 0;
        System.arraycopy(pData, 0, b, off, pData.length);
        off += pData.length;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 17 && b2[3] == 0) {
                rtnFlag = true;
                break;
            }
            if (b2[2] != 17 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean replace(String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1 + pData.length;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 18;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nExptime), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nDataLen), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, len);
        off += len;
        b[off++] = 0;
        System.arraycopy(pData, 0, b, off, pData.length);
        off += pData.length;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 18 && b2[3] == 0) {
                rtnFlag = true;
                break;
            }
            if (b2[2] != 18 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean set(String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        byte[] b2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u6267\u884cSet\u64cd\u4f5c\uff0cKey\u4e3a:" + strKey + ",Value\u4e3a\uff1a" + ByteUtil.decodeString(pData)));
        }
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1 + pData.length;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 16;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nExptime), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nDataLen), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, len);
        off += len;
        b[off++] = 0;
        System.arraycopy(pData, 0, b, off, pData.length);
        off += pData.length;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 16 && b2[3] == 0) {
                rtnFlag = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"\u6267\u884cSet\u64cd\u4f5c\u6210\u529f\uff01");
                break;
            }
            if (b2[2] != 16 || b2[3] == 0) continue;
            rtnFlag = false;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("\u6267\u884cSet\u64cd\u4f5c\u5931\u8d25\uff01\u5931\u8d25\u4ee3\u7801\u4e3a\uff1a" + b2[3]));
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean appendItem(String strKey, byte[] pData, int nDataLen, int nExptime) throws Exception {
        byte[] b2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u6267\u884cAppendItem\u64cd\u4f5c\uff0cKey\u4e3a:" + strKey + ",Value\u4e3a\uff1a" + ByteUtil.decodeString(pData)));
        }
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int keyLength = ByteUtil.encode(strKey).length;
        int totalLength = 16 + keyLength + 1 + pData.length;
        byte[] b = new byte[totalLength];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 19;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(totalLength), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nExptime), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(nDataLen), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, keyLength);
        off += keyLength;
        b[off++] = 0;
        System.arraycopy(pData, 0, b, off, pData.length);
        off += pData.length;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 19 && b2[3] == 0) {
                rtnFlag = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"\u6267\u884cAppendItem\u64cd\u4f5c\u6210\u529f\uff01");
                break;
            }
            if (b2[2] != 19 || b2[3] == 0) continue;
            rtnFlag = false;
            String msg = new String(b2, 8, b2.length - 8, "GBK");
            log.debug((Object)("\u6267\u884cAppendItem\u64cd\u4f5c\u5931\u8d25\uff01\u5931\u8d25\u4ee3\u7801\u4e3a\uff1a" + b2[3] + "," + msg));
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean delete(String strKey) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 12 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 48;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeIntegerToNetwork(0), 0, b, off += 4, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 48 && b2[3] == 0) {
                rtnFlag = true;
                break;
            }
            if (b2[2] != 48 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean flushAll() throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        byte[] b = new byte[8];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = -86;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(8), 0, b, off, 4);
        off += 4;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == -86 && b2[3] == 0) {
                rtnFlag = true;
                break;
            }
            if (b2[2] != -86 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean get(String strKey) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 8 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 32;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 32 && b2[3] == 0) {
                byte[] b3 = new byte[len];
                System.arraycopy(b2, 16, b3, 0, len);
                if (!ByteUtil.decodeString(b3).equals(strKey)) continue;
                this.itemID = ByteUtil.decodeLongFromNetwork(b2, 8);
                int len3 = 16 + len + 1 + 4;
                this.data = new byte[b2.length - len3];
                System.arraycopy(b2, len3, this.data, 0, b2.length - len3);
                rtnFlag = true;
                break;
            }
            if (b2[2] != 32 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean getAndDelete(String strKey) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 8 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 35;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 4, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 35 && b2[3] == 0) {
                byte[] b3 = new byte[len];
                System.arraycopy(b2, 16, b3, 0, len);
                if (!ByteUtil.decodeString(b3).equals(strKey)) continue;
                this.itemID = ByteUtil.decodeLongFromNetwork(b2, 8);
                int len3 = 16 + len + 1 + 4;
                this.data = new byte[b2.length - len3];
                System.arraycopy(b2, len3, this.data, 0, b2.length - len3);
                rtnFlag = true;
                break;
            }
            if (b2[2] != 35 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean getItem(String strKey, long nMinItemID) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 33;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeLongToNetwork(nMinItemID), 0, b, off += 4, 8);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 8, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 33 && b2[3] == 0) {
                byte[] b3 = new byte[len];
                System.arraycopy(b2, 16, b3, 0, len);
                if (!ByteUtil.decodeString(b3).equals(strKey)) continue;
                this.itemID = ByteUtil.decodeLongFromNetwork(b2, 8);
                int len3 = 16 + len + 1 + 4;
                this.data = new byte[b2.length - len3];
                System.arraycopy(b2, len3, this.data, 0, b2.length - len3);
                rtnFlag = true;
                break;
            }
            if (b2[2] != 33 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean getItemAndDelete(String strKey, long nMinItemID) throws Exception {
        byte[] b2;
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 34;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeLongToNetwork(nMinItemID), 0, b, off += 4, 8);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 8, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 34 && b2[3] == 0) {
                byte[] b3 = new byte[len];
                System.arraycopy(b2, 16, b3, 0, len);
                if (!ByteUtil.decodeString(b3).equals(strKey)) continue;
                this.itemID = ByteUtil.decodeLongFromNetwork(b2, 8);
                int len3 = 16 + len + 1 + 4;
                this.data = new byte[b2.length - len3];
                System.arraycopy(b2, len3, this.data, 0, b2.length - len3);
                rtnFlag = true;
                break;
            }
            if (b2[2] != 34 || b2[3] == 0) continue;
            rtnFlag = false;
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean getItemAll(String strKey, long nMinItemID) throws Exception {
        byte[] b2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u6267\u884cGetItemAll\u64cd\u4f5c\uff0cKey\u4e3a:" + strKey + ",MinItemID\u4e3a\uff1a" + nMinItemID));
        }
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 36;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeLongToNetwork(nMinItemID), 0, b, off += 4, 8);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 8, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 36 && b2[3] == 0) {
                byte[] b3 = new byte[len];
                System.arraycopy(b2, 16, b3, 0, len);
                if (!ByteUtil.decodeString(b3).equals(strKey)) continue;
                this.itemID = ByteUtil.decodeLongFromNetwork(b2, 8);
                int len3 = 16 + len + 1 + 4;
                this.data = new byte[b2.length - len3];
                System.arraycopy(b2, len3, this.data, 0, b2.length - len3);
                rtnFlag = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("\u6267\u884cGetItemAll\u64cd\u4f5c\u6210\u529f\uff01\u8fd4\u56de\u7684Value\u4e3a\uff1a" + ByteUtil.decodeString(this.data)));
                break;
            }
            if (b2[2] != 36 || b2[3] == 0) continue;
            rtnFlag = false;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("\u6267\u884cGetItemAll\u64cd\u4f5c\u5931\u8d25\uff01\u5931\u8d25\u4ee3\u7801\u4e3a\uff1a" + b2[3]));
            break;
        }
        return rtnFlag;
    }

    public synchronized boolean getItemAllAndDelete(String strKey, long nMinItemID) throws Exception {
        byte[] b2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("\u6267\u884cGetItemAllAndDelete\u64cd\u4f5c\uff0cKey\u4e3a:" + strKey + ",MinItemID\u4e3a\uff1a" + nMinItemID));
        }
        if (this.sock == null || !this.sock.isConnected()) {
            throw new IOException("++++ attempting to write to closed socket");
        }
        int len = ByteUtil.encode(strKey).length;
        int len2 = 16 + len + 1;
        byte[] b = new byte[len2];
        int off = 0;
        b[off++] = -2;
        b[off++] = 16;
        b[off++] = 37;
        b[off++] = 0;
        System.arraycopy(ByteUtil.encodeIntegerToHost(len2), 0, b, off, 4);
        System.arraycopy(ByteUtil.encodeLongToNetwork(nMinItemID), 0, b, off += 4, 8);
        System.arraycopy(ByteUtil.encode(strKey), 0, b, off += 8, len);
        off += len;
        b[off++] = 0;
        this.out.write(b);
        this.out.flush();
        boolean rtnFlag = false;
        while ((b2 = this.readResponse()) != null) {
            if (b2[2] == 37 && b2[3] == 0) {
                byte[] b3 = new byte[len];
                System.arraycopy(b2, 16, b3, 0, len);
                if (!ByteUtil.decodeString(b3).equals(strKey)) continue;
                this.itemID = ByteUtil.decodeLongFromNetwork(b2, 8);
                int len3 = 16 + len + 1 + 4;
                this.data = new byte[b2.length - len3];
                System.arraycopy(b2, len3, this.data, 0, b2.length - len3);
                rtnFlag = true;
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("\u6267\u884cGetItemAllAndDelete\u64cd\u4f5c\u6210\u529f\uff01\u8fd4\u56de\u7684Value\u4e3a\uff1a" + ByteUtil.decodeString(this.data)));
                break;
            }
            if (b2[2] != 37 || b2[3] == 0) continue;
            rtnFlag = false;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)("\u6267\u884cGetItemAllAndDelete\u64cd\u4f5c\u5931\u8d25\uff01\u5931\u8d25\u4ee3\u7801\u4e3a\uff1a" + b2[3]));
            break;
        }
        return rtnFlag;
    }

    private boolean readBytes(byte[] bytes, int off, int length) throws IOException {
        int readLen = 0;
        int dataLen = length;
        while ((readLen = this.in.read(bytes, off, dataLen)) != -1) {
            off += readLen;
            if ((dataLen -= readLen) <= 0) break;
        }
        return dataLen == 0;
    }

    private byte[] readResponse() throws IOException {
        byte[] b = new byte[8];
        int i = this.in.read();
        boolean endFlag = false;
        while (i != 254) {
            if (i == -1) {
                endFlag = true;
                break;
            }
            i = this.in.read();
        }
        if (endFlag) {
            return null;
        }
        b[0] = -2;
        if (!this.readBytes(b, 1, 7)) {
            log.warn((Object)"\u8bfb\u53d6\u5305\u59347\u4e2a\u5b57\u8282\u9519\u8bef\uff01");
            return null;
        }
        int len2 = ByteUtil.decodeIntegerFromHost(b, 4);
        if (len2 - 8 < 0) {
            log.warn((Object)"\u6570\u636e\u5305\u957f\u5ea6\u503c\u9519\u8bef\uff01");
            return null;
        }
        byte[] b4 = new byte[len2];
        System.arraycopy(b, 0, b4, 0, 8);
        int dataLen = len2 - 8;
        if (!this.readBytes(b4, 8, dataLen)) {
            log.warn((Object)"\u8bfb\u53d6\u62a5\u6570\u636e\u90e8\u5206\u5931\u8d25");
            return null;
        }
        return b4;
    }

    public synchronized void setStrName(String strName) {
        this.strName = strName;
    }

    public synchronized void setNID(int nID) {
        this.nID = nID;
    }

    public synchronized void setStrIP(String strIP) {
        this.strIP = strIP;
    }

    public synchronized void setNPort(int nPort) {
        this.nPort = nPort;
    }

    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public synchronized void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public boolean isLogonFlag() {
        return this.logonFlag;
    }

    public synchronized long getItemID() {
        return this.itemID;
    }

    public synchronized byte[] getData() {
        return this.data;
    }
}

