/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.dao;

import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.CassandraClientPoolFactory;
import me.prettyprint.cassandra.service.Keyspace;
import org.apache.cassandra.thrift.ConsistencyLevel;

public abstract class Command<OUTPUT> {
    public abstract OUTPUT execute(Keyspace var1) throws Exception;

    public final OUTPUT execute(String host, int port, String keyspace) throws Exception {
        return this.execute(this.getPool().borrowClient(host, port), keyspace, CassandraClient.DEFAULT_CONSISTENCY_LEVEL);
    }

    public final OUTPUT execute(String hostPort, String keyspace) throws Exception {
        return this.execute(this.getPool().borrowClient(hostPort), keyspace, CassandraClient.DEFAULT_CONSISTENCY_LEVEL);
    }

    public final OUTPUT execute(String[] hosts, String keyspace) throws Exception {
        return this.execute(this.getPool().borrowClient(hosts), keyspace, CassandraClient.DEFAULT_CONSISTENCY_LEVEL);
    }

    public final OUTPUT execute(String[] hosts, String keyspace, ConsistencyLevel consistency) throws Exception {
        return this.execute(this.getPool().borrowClient(hosts), keyspace, consistency);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final OUTPUT execute(CassandraClient c, String keyspace, ConsistencyLevel consistency) throws Exception {
        Keyspace ks = c.getKeyspace(keyspace, consistency);
        try {
            OUTPUT OUTPUT = this.execute(ks);
            return OUTPUT;
        }
        finally {
            this.getPool().releaseClient(ks.getClient());
        }
    }

    protected CassandraClientPool getPool() {
        return CassandraClientPoolFactory.INSTANCE.get();
    }
}

