/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.dao;

import me.prettyprint.cassandra.dao.Command;
import me.prettyprint.cassandra.service.Keyspace;
import me.prettyprint.cassandra.utils.StringUtils;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.NotFoundException;

public class ExampleDao {
    private static final String CASSANDRA_KEYSPACE = "Keyspace1";
    private static final int CASSANDRA_PORT = 9170;
    private static final String CASSANDRA_HOST = "localhost";
    private final String CF_NAME = "Standard1";
    private final String COLUMN_NAME = "v";

    public static void main(String[] args) throws Exception {
        ExampleDao ed = new ExampleDao();
        ed.insert("key1", "value1");
        System.out.println(ed.get("key1"));
    }

    public void insert(final String key, final String value) throws Exception {
        ExampleDao.execute(new Command<Void>(){

            @Override
            public Void execute(Keyspace ks) throws Exception {
                ks.insert(key, ExampleDao.this.createColumnPath("v"), StringUtils.bytes(value));
                return null;
            }
        });
    }

    public String get(final String key) throws Exception {
        return ExampleDao.execute(new Command<String>(){

            @Override
            public String execute(Keyspace ks) throws Exception {
                try {
                    return StringUtils.string(ks.getColumn(key, ExampleDao.this.createColumnPath("v")).getValue());
                }
                catch (NotFoundException e) {
                    return null;
                }
            }
        });
    }

    public void delete(final String key) throws Exception {
        ExampleDao.execute(new Command<Void>(){

            @Override
            public Void execute(Keyspace ks) throws Exception {
                ks.remove(key, ExampleDao.this.createColumnPath("v"));
                return null;
            }
        });
    }

    protected static <T> T execute(Command<T> command) throws Exception {
        return command.execute(CASSANDRA_HOST, 9170, CASSANDRA_KEYSPACE);
    }

    protected ColumnPath createColumnPath(String columnName) {
        ColumnPath columnPath = new ColumnPath("Standard1");
        columnPath.setColumn(columnName.getBytes());
        return columnPath;
    }
}

