/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.dao;

import me.prettyprint.cassandra.dao.SpringCommand;
import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.Keyspace;
import me.prettyprint.cassandra.utils.StringUtils;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.NotFoundException;

public class ExampleSpringDao {
    private static String CASSANDRA_KEYSPACE = "Keyspace1";
    private static String CF_NAME = "Standard1";
    private static String COLUMN_NAME = "v";
    private String keyspace = CASSANDRA_KEYSPACE;
    private String columnFamilyName = CF_NAME;
    private String columnName = COLUMN_NAME;
    private ConsistencyLevel consistencyLevel = CassandraClient.DEFAULT_CONSISTENCY_LEVEL;
    private CassandraClientPool cassandraClientPool;

    public ExampleSpringDao(CassandraClientPool cassandraClientPool) {
        this.cassandraClientPool = cassandraClientPool;
    }

    public void insert(final String key, final String value) throws Exception {
        this.execute(new SpringCommand<Void>(this.cassandraClientPool){

            @Override
            public Void execute(Keyspace ks) throws Exception {
                ks.insert(key, ExampleSpringDao.this.createColumnPath(ExampleSpringDao.this.columnName), StringUtils.bytes(value));
                return null;
            }
        });
    }

    public String get(final String key) throws Exception {
        return this.execute(new SpringCommand<String>(this.cassandraClientPool){

            @Override
            public String execute(Keyspace ks) throws Exception {
                try {
                    return StringUtils.string(ks.getColumn(key, ExampleSpringDao.this.createColumnPath(ExampleSpringDao.this.columnName)).getValue());
                }
                catch (NotFoundException e) {
                    return null;
                }
            }
        });
    }

    public void delete(final String key) throws Exception {
        this.execute(new SpringCommand<Void>(this.cassandraClientPool){

            @Override
            public Void execute(Keyspace ks) throws Exception {
                ks.remove(key, ExampleSpringDao.this.createColumnPath(ExampleSpringDao.this.columnName));
                return null;
            }
        });
    }

    protected ColumnPath createColumnPath(String columnName) {
        return new ColumnPath(this.columnFamilyName).setColumn(StringUtils.bytes(columnName));
    }

    protected <T> T execute(SpringCommand<T> command) throws Exception {
        return command.execute(this.keyspace, this.consistencyLevel);
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setColumnFamilyName(String columnFamilyName) {
        this.columnFamilyName = columnFamilyName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }
}

