/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.Deletion;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.SuperColumn;

public class BatchMutation {
    Map<String, Map<String, List<Mutation>>> mutationMap = new HashMap<String, Map<String, List<Mutation>>>();

    public BatchMutation addInsertion(String key, List<String> columnFamilies, Column column) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setColumn(column));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation addSuperInsertion(String key, List<String> columnFamilies, SuperColumn superColumn) {
        Mutation mutation = new Mutation();
        mutation.setColumn_or_supercolumn(new ColumnOrSuperColumn().setSuper_column(superColumn));
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    public BatchMutation addDeletion(String key, List<String> columnFamilies, Deletion deletion) {
        Mutation mutation = new Mutation();
        mutation.setDeletion(deletion);
        this.addMutation(key, columnFamilies, mutation);
        return this;
    }

    private void addMutation(String key, List<String> columnFamilies, Mutation mutation) {
        Map<String, List<Mutation>> innerMutationMap = this.getInnerMutationMap(key);
        for (String columnFamily : columnFamilies) {
            if (innerMutationMap.get(columnFamily) == null) {
                innerMutationMap.put(columnFamily, Arrays.asList(mutation));
                continue;
            }
            ArrayList<Mutation> mutations = new ArrayList<Mutation>((Collection)innerMutationMap.get(columnFamily));
            mutations.add(mutation);
            innerMutationMap.put(columnFamily, mutations);
        }
        this.mutationMap.put(key, innerMutationMap);
    }

    private Map<String, List<Mutation>> getInnerMutationMap(String key) {
        Map<String, List<Mutation>> innerMutationMap = this.mutationMap.get(key);
        if (innerMutationMap == null) {
            innerMutationMap = new HashMap<String, List<Mutation>>();
        }
        return innerMutationMap;
    }

    Map<String, Map<String, List<Mutation>>> getMutationMap() {
        return this.mutationMap;
    }
}

