/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.prettyprint.cassandra.service.Keyspace;
import me.prettyprint.cassandra.service.TimestampResolution;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.thrift.TException;

public interface CassandraClient {
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.QUORUM;
    public static final FailoverPolicy DEFAULT_FAILOVER_POLICY = FailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE;

    public Cassandra.Client getCassandra();

    public Keyspace getKeyspace(String var1) throws IllegalArgumentException, NotFoundException, TException;

    public Keyspace getKeyspace(String var1, ConsistencyLevel var2) throws IllegalArgumentException, NotFoundException, TException;

    public Keyspace getKeyspace(String var1, ConsistencyLevel var2, FailoverPolicy var3) throws IllegalArgumentException, NotFoundException, TException;

    public String getStringProperty(String var1) throws TException;

    public List<String> getKeyspaces() throws TException;

    public String getClusterName() throws TException;

    public Map<String, String> getTokenMap(boolean var1) throws TException;

    public String getConfigFile() throws TException;

    public String getServerVersion() throws TException;

    public int getPort();

    public String getUrl();

    public void updateKnownHosts() throws TException;

    public void markAsClosed();

    public boolean isClosed();

    public Set<String> getKnownHosts();

    public String getIp();

    public void markAsError();

    public boolean hasErrors();

    public void removeKeyspace(Keyspace var1);

    public TimestampResolution getTimestampResolution();

    public static enum FailoverPolicy {
        FAIL_FAST(0),
        ON_FAIL_TRY_ONE_NEXT_AVAILABLE(1),
        ON_FAIL_TRY_ALL_AVAILABLE(0x7FFFFFFE);

        private final int numRetries;

        private FailoverPolicy(int numRetries) {
            this.numRetries = numRetries;
        }

        public int getNumRetries() {
            return this.numRetries;
        }
    }
}

