/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.net.UnknownHostException;
import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientImpl;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.CassandraClientPoolImpl;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.KeyspaceFactory;
import me.prettyprint.cassandra.service.SystemProperties;
import me.prettyprint.cassandra.service.TimestampResolution;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientFactory
implements PoolableObjectFactory {
    private final int timeout;
    private final CassandraClientMonitor clientMonitor;
    private static final Logger log = LoggerFactory.getLogger(CassandraClientFactory.class);
    private final CassandraClientPool pool;
    private final String url;
    private final int port;
    private final boolean useThriftFramedTransport;
    private final TimestampResolution timestampResolution;

    public CassandraClientFactory(CassandraClientPool pools, CassandraHost cassandraHost, CassandraClientMonitor clientMonitor) {
        this.pool = pools;
        this.url = cassandraHost.getUrl();
        this.port = cassandraHost.getPort();
        this.timeout = this.getTimeout(cassandraHost);
        this.clientMonitor = clientMonitor;
        this.useThriftFramedTransport = cassandraHost.getUseThriftFramedTransport();
        this.timestampResolution = cassandraHost.getTimestampResolution();
    }

    public CassandraClientFactory(String url, int port) {
        this.clientMonitor = new CassandraClientMonitor();
        this.pool = new CassandraClientPoolImpl(this.clientMonitor);
        this.url = url;
        this.port = port;
        this.timeout = this.getTimeout(null);
        this.useThriftFramedTransport = false;
        this.timestampResolution = CassandraHost.DEFAULT_TIMESTAMP_RESOLUTION;
    }

    public CassandraClient create() throws TTransportException, TException, UnknownHostException {
        return new CassandraClientImpl(this.createThriftClient(this.url, this.port), new KeyspaceFactory(this.clientMonitor), this.url, this.port, this.pool, this.timestampResolution);
    }

    private Cassandra.Client createThriftClient(String url, int port) throws TTransportException, TException {
        log.debug("Creating a new thrift connection to {}:{}", (Object)url, (Object)port);
        Object tr = this.useThriftFramedTransport ? new TFramedTransport((TTransport)new TSocket(url, port, this.timeout)) : new TSocket(url, port, this.timeout);
        TBinaryProtocol proto = new TBinaryProtocol((TTransport)tr);
        Cassandra.Client client = new Cassandra.Client((TProtocol)proto);
        try {
            tr.open();
        }
        catch (TTransportException e) {
            log.error("Unable to open transport to " + url + ":" + port, (Throwable)e);
            this.clientMonitor.incCounter(CassandraClientMonitor.Counter.CONNECT_ERROR);
            throw new TTransportException("Unable to open transport to " + url + ":" + port + " , " + e.getLocalizedMessage(), (Throwable)e);
        }
        return client;
    }

    private int getTimeout(CassandraHost cassandraHost) {
        int timeoutVar = 0;
        if (cassandraHost != null && cassandraHost.getCassandraThriftSocketTimeout() > 0) {
            timeoutVar = cassandraHost.getCassandraThriftSocketTimeout();
        } else {
            String timeoutStr = System.getProperty(SystemProperties.CASSANDRA_THRIFT_SOCKET_TIMEOUT.toString());
            if (timeoutStr != null && timeoutStr.length() > 0) {
                try {
                    timeoutVar = Integer.valueOf(timeoutStr);
                }
                catch (NumberFormatException e) {
                    log.error("Invalid value for CASSANDRA_THRIFT_SOCKET_TIMEOUT", (Throwable)e);
                }
            }
        }
        return timeoutVar;
    }

    public void activateObject(Object obj) throws Exception {
    }

    public void destroyObject(Object obj) throws Exception {
        CassandraClient client = (CassandraClient)obj;
        log.debug("Close client {}", (Object)client);
        this.closeClient(client);
    }

    public Object makeObject() throws Exception {
        log.debug("Creating a new client...");
        CassandraClient c = this.create();
        log.debug("New client created: {}", (Object)c);
        return c;
    }

    public boolean validateObject(Object obj) {
        return this.validateClient((CassandraClient)obj);
    }

    private boolean validateClient(CassandraClient client) {
        return !client.isClosed() && !client.hasErrors();
    }

    private void closeClient(CassandraClient cclient) {
        log.debug("Closing client {}", (Object)cclient);
        ((CassandraClientPoolImpl)this.pool).reportDestroyed(cclient);
        Cassandra.Client client = cclient.getCassandra();
        client.getInputProtocol().getTransport().close();
        client.getOutputProtocol().getTransport().close();
        cclient.markAsClosed();
    }

    public void passivateObject(Object obj) throws Exception {
    }
}

