/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.Keyspace;
import me.prettyprint.cassandra.service.KeyspaceFactory;
import me.prettyprint.cassandra.service.KeyspaceImpl;
import me.prettyprint.cassandra.service.TimestampResolution;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientImpl
implements CassandraClient {
    private static final String PROP_CLUSTER_NAME = "cluster name";
    private static final String PROP_CONFIG_FILE = "config file";
    private static final String PROP_TOKEN_MAP = "token map";
    private static final String PROP_KEYSPACE = "keyspaces";
    private static final String PROP_VERSION = "version";
    private static final Logger log = LoggerFactory.getLogger(CassandraClientImpl.class);
    private static final AtomicLong serial = new AtomicLong(0L);
    private final long mySerial;
    private final Cassandra.Client cassandra;
    private final TimestampResolution timestampResolution;
    private List<String> keyspaces;
    private final ConcurrentHashMap<String, KeyspaceImpl> keyspaceMap = new ConcurrentHashMap();
    private String clusterName;
    private Map<String, String> tokenMap;
    private String configFile;
    private String serverVersion;
    private final KeyspaceFactory keyspaceFactory;
    private final int port;
    private final String url;
    private final String ip;
    private final CassandraClientPool clientPools;
    private boolean closed = false;
    private boolean hasErrors = false;

    public CassandraClientImpl(Cassandra.Client cassandraThriftClient, KeyspaceFactory keyspaceFactory, String url, int port, CassandraClientPool clientPools, TimestampResolution timestampResolution) throws UnknownHostException {
        this.mySerial = serial.incrementAndGet();
        this.cassandra = cassandraThriftClient;
        this.keyspaceFactory = keyspaceFactory;
        this.port = port;
        this.url = url;
        this.ip = CassandraClientImpl.getIpString(url);
        this.clientPools = clientPools;
        this.timestampResolution = timestampResolution;
    }

    private static String getIpString(String url) throws UnknownHostException {
        return InetAddress.getByName(url).getHostAddress();
    }

    @Override
    public String getClusterName() throws TException {
        if (this.clusterName == null) {
            this.clusterName = this.getStringProperty(PROP_CLUSTER_NAME);
        }
        return this.clusterName;
    }

    @Override
    public String getConfigFile() throws TException {
        if (this.configFile == null) {
            this.configFile = this.getStringProperty(PROP_CONFIG_FILE);
        }
        return this.configFile;
    }

    @Override
    public Keyspace getKeyspace(String keySpaceName) throws IllegalArgumentException, NotFoundException, TException {
        return this.getKeyspace(keySpaceName, DEFAULT_CONSISTENCY_LEVEL, DEFAULT_FAILOVER_POLICY);
    }

    @Override
    public Keyspace getKeyspace(String keySpaceName, ConsistencyLevel consistency) throws IllegalArgumentException, NotFoundException, TException {
        return this.getKeyspace(keySpaceName, consistency, DEFAULT_FAILOVER_POLICY);
    }

    @Override
    public Keyspace getKeyspace(String keyspaceName, ConsistencyLevel consistencyLevel, CassandraClient.FailoverPolicy failoverPolicy) throws IllegalArgumentException, NotFoundException, TException {
        String keyspaceMapKey = this.buildKeyspaceMapName(keyspaceName, consistencyLevel, failoverPolicy);
        KeyspaceImpl keyspace = this.keyspaceMap.get(keyspaceMapKey);
        if (keyspace == null) {
            if (this.getKeyspaces().contains(keyspaceName)) {
                Map keyspaceDesc = this.cassandra.describe_keyspace(keyspaceName);
                keyspace = (KeyspaceImpl)this.keyspaceFactory.create(this, keyspaceName, keyspaceDesc, consistencyLevel, failoverPolicy, this.clientPools);
                KeyspaceImpl tmp = this.keyspaceMap.putIfAbsent(keyspaceMapKey, keyspace);
                if (tmp != null) {
                    keyspace = tmp;
                }
            } else {
                throw new IllegalArgumentException("Requested key space not exist, keyspaceName=" + keyspaceName);
            }
        }
        return keyspace;
    }

    @Override
    public List<String> getKeyspaces() throws TException {
        if (this.keyspaces == null) {
            this.keyspaces = this.cassandra.get_string_list_property(PROP_KEYSPACE);
        }
        return this.keyspaces;
    }

    @Override
    public String getStringProperty(String propertyName) throws TException {
        return this.cassandra.get_string_property(propertyName);
    }

    @Override
    public Map<String, String> getTokenMap(boolean fresh) throws TException {
        if (this.tokenMap == null || fresh) {
            String[] tokenPairs;
            this.tokenMap = new HashMap<String, String>();
            String strTokens = this.getStringProperty(PROP_TOKEN_MAP);
            strTokens = this.trimBothSides(strTokens);
            for (String tokenPair : tokenPairs = strTokens.split(",")) {
                String[] keyValue = tokenPair.split(":");
                String token = this.trimBothSides(keyValue[0]);
                String host = this.trimBothSides(keyValue[1]);
                this.tokenMap.put(token, host);
            }
        }
        return this.tokenMap;
    }

    @Override
    public String getServerVersion() throws TException {
        if (this.serverVersion == null) {
            this.serverVersion = this.getStringProperty(PROP_VERSION);
        }
        return this.serverVersion;
    }

    private String buildKeyspaceMapName(String keyspaceName, ConsistencyLevel consistencyLevel, CassandraClient.FailoverPolicy failoverPolicy) {
        StringBuilder b = new StringBuilder(keyspaceName);
        b.append('[');
        b.append(consistencyLevel.getValue());
        b.append(',');
        b.append((Object)failoverPolicy);
        b.append(']');
        return b.toString();
    }

    @Override
    public Cassandra.Client getCassandra() {
        return this.cassandra;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void updateKnownHosts() throws TException {
        if (this.closed) {
            return;
        }
        for (KeyspaceImpl k : this.keyspaceMap.values()) {
            k.updateKnownHosts();
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CassandraClient<");
        b.append(this.getUrl());
        b.append(":");
        b.append(this.getPort());
        b.append("-");
        b.append(this.mySerial);
        b.append(">");
        return b.toString();
    }

    @Override
    public void markAsClosed() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Set<String> getKnownHosts() {
        HashSet<String> hosts = new HashSet<String>();
        if (this.closed) {
            return hosts;
        }
        for (KeyspaceImpl k : this.keyspaceMap.values()) {
            hosts.addAll(k.getKnownHosts());
        }
        return hosts;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    @Override
    public void markAsError() {
        this.hasErrors = true;
    }

    @Override
    public void removeKeyspace(Keyspace k) {
        String key = this.buildKeyspaceMapName(k.getName(), k.getConsistencyLevel(), k.getFailoverPolicy());
        this.keyspaceMap.remove(key);
    }

    @Override
    public TimestampResolution getTimestampResolution() {
        return this.timestampResolution;
    }

    private String trimBothSides(String str) {
        str = str.substring(1);
        str = str.substring(0, str.length() - 1);
        return str;
    }
}

