/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.service.CassandraClientMonitorMBean;
import me.prettyprint.cassandra.service.CassandraClientPool;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientMonitor
implements CassandraClientMonitorMBean {
    private static final Logger log = LoggerFactory.getLogger(CassandraClientMonitor.class);
    private final Map<Counter, AtomicLong> counters;
    private final Set<CassandraClientPool> pools = Collections.newSetFromMap(new ConcurrentHashMap());

    public CassandraClientMonitor() {
        this.counters = new HashMap<Counter, AtomicLong>();
        for (Counter counter : Counter.values()) {
            this.counters.put(counter, new AtomicLong(0L));
        }
    }

    public void incCounter(Counter counterType) {
        this.counters.get((Object)counterType).incrementAndGet();
    }

    public long getWriteSuccess() {
        return this.counters.get((Object)Counter.WRITE_SUCCESS).longValue();
    }

    @Override
    public long getReadFail() {
        return this.counters.get((Object)Counter.READ_FAIL).longValue();
    }

    public long getReadSuccess() {
        return this.counters.get((Object)Counter.READ_SUCCESS).longValue();
    }

    @Override
    public long getSkipHostSuccess() {
        return this.counters.get((Object)Counter.SKIP_HOST_SUCCESS).longValue();
    }

    @Override
    public long getRecoverableTimedOutCount() {
        return this.counters.get((Object)Counter.RECOVERABLE_TIMED_OUT_EXCEPTIONS).longValue();
    }

    @Override
    public long getRecoverableUnavailableCount() {
        return this.counters.get((Object)Counter.RECOVERABLE_UNAVAILABLE_EXCEPTIONS).longValue();
    }

    @Override
    public long getWriteFail() {
        return this.counters.get((Object)Counter.WRITE_FAIL).longValue();
    }

    @Override
    public void updateKnownHosts() throws TException {
        log.info("Updating all known cassandra hosts on all clients");
        for (CassandraClientPool pool : this.pools) {
            pool.updateKnownHosts();
        }
    }

    @Override
    public long getNumPoolExhaustedEventCount() {
        return this.counters.get((Object)Counter.POOL_EXHAUSTED).longValue();
    }

    @Override
    public Set<String> getExhaustedPoolNames() {
        HashSet<String> ret = new HashSet<String>();
        for (CassandraClientPool pool : this.pools) {
            ret.addAll(pool.getExhaustedPoolNames());
        }
        return ret;
    }

    @Override
    public int getNumActive() {
        int ret = 0;
        for (CassandraClientPool pool : this.pools) {
            ret += pool.getNumActive();
        }
        return ret;
    }

    @Override
    public int getNumBlockedThreads() {
        int ret = 0;
        for (CassandraClientPool pool : this.pools) {
            ret += pool.getNumBlockedThreads();
        }
        return ret;
    }

    @Override
    public int getNumExhaustedPools() {
        int ret = 0;
        for (CassandraClientPool pool : this.pools) {
            ret += pool.getNumExhaustedPools();
        }
        return ret;
    }

    @Override
    public int getNumIdleConnections() {
        int ret = 0;
        for (CassandraClientPool pool : this.pools) {
            ret += pool.getNumIdle();
        }
        return ret;
    }

    @Override
    public int getNumPools() {
        int ret = 0;
        for (CassandraClientPool pool : this.pools) {
            ret += pool.getNumPools();
        }
        return ret;
    }

    @Override
    public Set<String> getPoolNames() {
        HashSet<String> ret = new HashSet<String>();
        for (CassandraClientPool pool : this.pools) {
            ret.addAll(pool.getPoolNames());
        }
        return ret;
    }

    @Override
    public Set<String> getKnownHosts() {
        HashSet<String> ret = new HashSet<String>();
        for (CassandraClientPool pool : this.pools) {
            ret.addAll(pool.getKnownHosts());
        }
        return ret;
    }

    @Override
    public long getRecoverableTransportExceptionCount() {
        return this.counters.get((Object)Counter.RECOVERABLE_TRANSPORT_EXCEPTIONS).longValue();
    }

    @Override
    public long getRecoverableErrorCount() {
        return this.getRecoverableTimedOutCount() + this.getRecoverableTransportExceptionCount() + this.getRecoverableUnavailableCount() + this.getRecoverableLoadBalancedConnectErrors();
    }

    public void addPool(CassandraClientPool pool) {
        this.pools.add(pool);
    }

    @Override
    public long getRecoverableLoadBalancedConnectErrors() {
        return this.counters.get((Object)Counter.RECOVERABLE_LB_CONNECT_ERRORS).longValue();
    }

    @Override
    public long getNumConnectionErrors() {
        return this.counters.get((Object)Counter.CONNECT_ERROR).longValue();
    }

    public static enum Counter {
        RECOVERABLE_TIMED_OUT_EXCEPTIONS,
        RECOVERABLE_UNAVAILABLE_EXCEPTIONS,
        RECOVERABLE_TRANSPORT_EXCEPTIONS,
        SKIP_HOST_SUCCESS,
        WRITE_SUCCESS,
        WRITE_FAIL,
        READ_SUCCESS,
        READ_FAIL,
        POOL_EXHAUSTED,
        RECOVERABLE_LB_CONNECT_ERRORS,
        CONNECT_ERROR;

    }
}

