/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientFactory;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.CassandraClientPoolByHost;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.ExhaustedPolicy;
import me.prettyprint.cassandra.service.PoolExhaustedException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.GenericObjectPoolFactory;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientPoolByHostImpl
implements CassandraClientPoolByHost {
    private static final Logger log = LoggerFactory.getLogger(CassandraClientPoolByHostImpl.class);
    private final CassandraClientFactory clientFactory;
    private final String url;
    private final String name;
    private final int port;
    private final int maxActive;
    private final int maxIdle;
    private final ExhaustedPolicy exhaustedPolicy;
    private final long maxWaitTimeWhenExhausted;
    private final GenericObjectPool pool;
    private final AtomicInteger blockedThreadsCount;
    private final Set<CassandraClient> liveClientsFromPool;

    public CassandraClientPoolByHostImpl(CassandraHost cassandraHost, CassandraClientPool pools, CassandraClientMonitor cassandraClientMonitor) {
        this(cassandraHost, pools, cassandraClientMonitor, new CassandraClientFactory(pools, cassandraHost, cassandraClientMonitor));
    }

    public CassandraClientPoolByHostImpl(CassandraHost cassandraHost, CassandraClientPool pools, CassandraClientMonitor cassandraClientMonitor, CassandraClientFactory cassandraClientFactory) {
        log.debug("Creating new connection pool for {}", (Object)cassandraHost.getUrlPort());
        this.url = cassandraHost.getUrl();
        this.port = cassandraHost.getPort();
        this.name = cassandraHost.getName();
        this.maxActive = cassandraHost.getMaxActive();
        this.maxIdle = cassandraHost.getMaxIdle();
        this.maxWaitTimeWhenExhausted = cassandraHost.getMaxWaitTimeWhenExhausted();
        this.exhaustedPolicy = cassandraHost.getExhaustedPolicy();
        this.clientFactory = cassandraClientFactory;
        this.blockedThreadsCount = new AtomicInteger(0);
        this.liveClientsFromPool = Collections.newSetFromMap(new ConcurrentHashMap());
        this.pool = this.createPool();
    }

    @Override
    public CassandraClient borrowClient() throws Exception, PoolExhaustedException, IllegalStateException {
        try {
            this.blockedThreadsCount.incrementAndGet();
            CassandraClient client = (CassandraClient)this.pool.borrowObject();
            this.liveClientsFromPool.add(client);
            CassandraClient cassandraClient = client;
            return cassandraClient;
        }
        catch (NoSuchElementException e) {
            throw new PoolExhaustedException(e.getMessage());
        }
        finally {
            this.blockedThreadsCount.decrementAndGet();
        }
    }

    @Override
    public void close() {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            log.error("Unable to close pool", (Throwable)e);
        }
    }

    @Override
    public int getNumIdle() {
        return this.pool.getNumIdle();
    }

    @Override
    public int getNumActive() {
        return this.pool.getNumActive();
    }

    @Override
    public int getNumBeforeExhausted() {
        return this.maxActive - this.pool.getNumActive();
    }

    @Override
    public void releaseClient(CassandraClient client) throws Exception {
        this.pool.returnObject((Object)client);
    }

    private GenericObjectPool createPool() {
        GenericObjectPoolFactory poolFactory = new GenericObjectPoolFactory((PoolableObjectFactory)this.clientFactory, this.maxActive, CassandraClientPoolByHostImpl.getObjectPoolExhaustedAction(this.exhaustedPolicy), this.maxWaitTimeWhenExhausted, this.maxIdle);
        GenericObjectPool p = (GenericObjectPool)poolFactory.createPool();
        p.setTestOnBorrow(true);
        p.setMaxIdle(-1);
        return p;
    }

    public static byte getObjectPoolExhaustedAction(ExhaustedPolicy exhaustedAction) {
        switch (exhaustedAction) {
            case WHEN_EXHAUSTED_FAIL: {
                return 0;
            }
            case WHEN_EXHAUSTED_BLOCK: {
                return 1;
            }
            case WHEN_EXHAUSTED_GROW: {
                return 2;
            }
        }
        return 1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CassandraClientPoolImpl<");
        b.append(this.url);
        b.append(":");
        b.append(this.port);
        b.append(">");
        return b.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isExhausted() {
        return this.getNumBeforeExhausted() <= 0 && (this.exhaustedPolicy.equals((Object)ExhaustedPolicy.WHEN_EXHAUSTED_BLOCK) || this.exhaustedPolicy.equals((Object)ExhaustedPolicy.WHEN_EXHAUSTED_FAIL));
    }

    @Override
    public int getNumBlockedThreads() {
        return this.blockedThreadsCount.intValue();
    }

    @Override
    public void updateKnownHosts() throws TException {
        HashSet<CassandraClient> removed = new HashSet<CassandraClient>();
        for (CassandraClient c : this.liveClientsFromPool) {
            if (c.isClosed()) {
                removed.add(c);
                continue;
            }
            try {
                c.updateKnownHosts();
            }
            catch (TException e) {
                log.error("Unable to update hosts list at {}", (Object)c, (Object)e);
                throw e;
            }
        }
        this.liveClientsFromPool.removeAll(removed);
    }

    @Override
    public Set<String> getKnownHosts() {
        HashSet<String> hosts = new HashSet<String>();
        for (CassandraClient c : this.liveClientsFromPool) {
            if (c.isClosed()) continue;
            hosts.addAll(c.getKnownHosts());
        }
        return hosts;
    }

    @Override
    public void invalidateClient(CassandraClient client) {
        try {
            this.liveClientsFromPool.remove(client);
            client.markAsError();
            this.pool.invalidateObject((Object)client);
        }
        catch (Exception e) {
            log.error("Unable to invalidate client " + client, (Throwable)e);
        }
    }

    @Override
    public Set<CassandraClient> getLiveClients() {
        return ImmutableSet.copyOf(this.liveClientsFromPool);
    }

    void reportDestroyed(CassandraClient client) {
        log.debug("Client has been destroyed: {}", (Object)client);
        this.liveClientsFromPool.remove(client);
    }

    @Override
    public void invalidateAll() {
        while (!this.liveClientsFromPool.isEmpty()) {
            this.invalidateClient(this.liveClientsFromPool.iterator().next());
        }
    }
}

