/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.CassandraClientPoolImpl;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.JmxMonitor;

public enum CassandraClientPoolFactory {
    INSTANCE;

    private CassandraClientPool defaultPool;

    public static CassandraClientPoolFactory getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CassandraClientPool get() {
        if (this.defaultPool == null) {
            CassandraClientPoolFactory cassandraClientPoolFactory = INSTANCE;
            synchronized (cassandraClientPoolFactory) {
                if (this.defaultPool == null) {
                    this.defaultPool = this.createDefault();
                }
            }
        }
        return this.defaultPool;
    }

    public CassandraClientPool createDefault() {
        CassandraClientPoolImpl pool = new CassandraClientPoolImpl(JmxMonitor.INSTANCE.getCassandraMonitor());
        JmxMonitor.INSTANCE.addPool(pool);
        return pool;
    }

    public CassandraClientPool createNew(CassandraHostConfigurator cassandraHostConfigurator) {
        CassandraClientPoolImpl pool = new CassandraClientPoolImpl(JmxMonitor.INSTANCE.getCassandraMonitor(), cassandraHostConfigurator.buildCassandraHosts());
        JmxMonitor.INSTANCE.addPool(pool);
        return pool;
    }
}

