/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.CassandraClientPoolByHost;
import me.prettyprint.cassandra.service.CassandraClientPoolByHostImpl;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.Keyspace;
import me.prettyprint.cassandra.service.PoolExhaustedException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CassandraClientPoolImpl
implements CassandraClientPool {
    private static final Logger log = LoggerFactory.getLogger(CassandraClientPoolImpl.class);
    private final Map<CassandraHost, CassandraClientPoolByHost> pools = new HashMap<CassandraHost, CassandraClientPoolByHost>();
    private final CassandraClientMonitor clientMonitor;

    public CassandraClientPoolImpl(CassandraClientMonitor clientMonitor) {
        this.clientMonitor = clientMonitor;
    }

    public CassandraClientPoolImpl(CassandraClientMonitor clientMonitor, CassandraHost[] cassandraHosts) {
        this(clientMonitor);
        for (CassandraHost cassandraHost : cassandraHosts) {
            log.debug("Creating pool-by-host instance: {}", (Object)cassandraHost);
            this.getPool(cassandraHost);
        }
    }

    @Override
    public CassandraClient borrowClient() throws IllegalStateException, PoolExhaustedException, Exception {
        String[] clients = new String[this.pools.size()];
        int x = 0;
        for (CassandraHost cassandraHost : this.pools.keySet()) {
            clients[x] = cassandraHost.getUrlPort();
            ++x;
        }
        return this.borrowClient(clients);
    }

    @Override
    public CassandraClient borrowClient(String url, int port) throws IllegalStateException, PoolExhaustedException, Exception {
        return this.getPool(new CassandraHost(url, port)).borrowClient();
    }

    @Override
    public Set<String> getExhaustedPoolNames() {
        HashSet<String> hosts = new HashSet<String>();
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            if (!pool.isExhausted()) continue;
            hosts.add(pool.getName());
        }
        return hosts;
    }

    @Override
    public int getNumActive() {
        int count = 0;
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            count += pool.getNumActive();
        }
        return count;
    }

    @Override
    public int getNumBlockedThreads() {
        int count = 0;
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            count += pool.getNumBlockedThreads();
        }
        return count;
    }

    @Override
    public int getNumExhaustedPools() {
        int count = 0;
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            if (!pool.isExhausted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getNumIdle() {
        int count = 0;
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            count += pool.getNumIdle();
        }
        return count;
    }

    @Override
    public int getNumPools() {
        return this.pools.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CassandraClientPoolByHost getPool(CassandraHost cassandraHost) {
        CassandraClientPoolByHost pool = this.pools.get(cassandraHost);
        if (pool == null) {
            Map<CassandraHost, CassandraClientPoolByHost> map = this.pools;
            synchronized (map) {
                pool = this.pools.get(cassandraHost);
                if (pool == null) {
                    pool = new CassandraClientPoolByHostImpl(cassandraHost, this, this.clientMonitor);
                    this.pools.put(cassandraHost, pool);
                }
            }
        }
        return pool;
    }

    @Override
    public Set<String> getPoolNames() {
        HashSet<String> names = new HashSet<String>();
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            names.add(pool.getName());
        }
        return names;
    }

    @Override
    public void releaseClient(CassandraClient client) throws Exception {
        this.getPool(client).releaseClient(client);
    }

    @Override
    public void updateKnownHosts() throws TException {
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            pool.updateKnownHosts();
        }
    }

    @Override
    public Set<String> getKnownHosts() {
        HashSet<String> hosts = new HashSet<String>();
        for (CassandraClientPoolByHost pool : this.pools.values()) {
            hosts.addAll(pool.getKnownHosts());
        }
        return hosts;
    }

    @Override
    public void invalidateClient(CassandraClient client) {
        this.getPool(client).invalidateClient(client);
    }

    void reportDestroyed(CassandraClient client) {
        ((CassandraClientPoolByHostImpl)this.getPool(client)).reportDestroyed(client);
    }

    private CassandraClientPoolByHost getPool(CassandraClient c) {
        return this.getPool(new CassandraHost(c.getUrl(), c.getPort()));
    }

    @Override
    public void releaseKeyspace(Keyspace k) throws Exception {
        this.releaseClient(k.getClient());
    }

    @Override
    public CassandraClient borrowClient(String urlPort) throws IllegalStateException, PoolExhaustedException, Exception {
        String url = this.parseHostFromUrl(urlPort);
        int port = this.parsePortFromUrl(urlPort);
        return this.borrowClient(url, port);
    }

    @Override
    public CassandraClient borrowClient(String[] clientUrls) throws Exception {
        ArrayList<String> clients = new ArrayList<String>(Arrays.asList(clientUrls));
        while (!clients.isEmpty()) {
            int rand = (int)(Math.random() * (double)clients.size());
            try {
                return this.borrowClient((String)clients.get(rand));
            }
            catch (Exception e) {
                if (clients.size() > 1) {
                    log.warn("Unable to obtain client " + (String)clients.get(rand) + " will try the next client", (Throwable)e);
                    this.clientMonitor.incCounter(CassandraClientMonitor.Counter.RECOVERABLE_LB_CONNECT_ERRORS);
                    clients.remove(rand);
                    continue;
                }
                throw e;
            }
        }
        return null;
    }

    private String parseHostFromUrl(String urlPort) {
        return urlPort.substring(0, urlPort.lastIndexOf(58));
    }

    private int parsePortFromUrl(String urlPort) {
        return Integer.valueOf(urlPort.substring(urlPort.lastIndexOf(58) + 1, urlPort.length()));
    }

    @Override
    public void invalidateAllConnectionsToHost(CassandraClient client) {
        this.getPool(client).invalidateAll();
    }
}

