/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import me.prettyprint.cassandra.service.ExhaustedPolicy;
import me.prettyprint.cassandra.service.SystemProperties;
import me.prettyprint.cassandra.service.TimestampResolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHost {
    private static Logger log = LoggerFactory.getLogger(CassandraHost.class);
    public static final int DEFAULT_MAX_ACTIVE = 50;
    public static final boolean DEFAULT_USE_FRAMED_THRIFT_TRANSPORT = false;
    public static final long DEFAULT_MAX_WAITTIME_WHEN_EXHAUSTED = -1L;
    public static final int DEFAULT_MAX_IDLE = 5;
    public static final TimestampResolution DEFAULT_TIMESTAMP_RESOLUTION = TimestampResolution.MICROSECONDS;
    private final String url;
    private final String ip;
    private final int port;
    private final String name;
    private int maxActive = 50;
    private int maxIdle = 5;
    private long maxWaitTimeWhenExhausted = -1L;
    private int cassandraThriftSocketTimeout;
    private ExhaustedPolicy exhaustedPolicy = ExhaustedPolicy.WHEN_EXHAUSTED_BLOCK;
    private boolean useThriftFramedTransport = false;
    private TimestampResolution timestampResolution = DEFAULT_TIMESTAMP_RESOLUTION;

    public CassandraHost(String urlPort) {
        this(CassandraHost.parseHostFromUrl(urlPort), CassandraHost.parsePortFromUrl(urlPort));
    }

    public CassandraHost(String url2, int port) {
        String tip;
        String turl;
        this.port = port;
        StringBuilder b = new StringBuilder();
        try {
            InetAddress address = InetAddress.getByName(url2);
            turl = this.isPerformNameResolution() ? address.getHostName() : url2;
            tip = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("Unable to resolve host {}", (Object)url2);
            turl = url2;
            tip = url2;
        }
        this.url = turl;
        this.ip = tip;
        b.append(url2);
        b.append("(");
        b.append(this.ip);
        b.append("):");
        b.append(port);
        this.name = b.toString();
    }

    public String getUrlPort() {
        return new StringBuilder(32).append(this.url).append(':').append(this.port).toString();
    }

    public boolean isPerformNameResolution() {
        String sysprop = System.getProperty(SystemProperties.HECTOR_PERFORM_NAME_RESOLUTION.toString());
        return sysprop != null && Boolean.valueOf(sysprop) != false;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CassandraHost)) {
            return false;
        }
        return ((CassandraHost)obj).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxWaitTimeWhenExhausted() {
        return this.maxWaitTimeWhenExhausted;
    }

    public void setMaxWaitTimeWhenExhausted(long maxWaitTimeWhenExhausted) {
        this.maxWaitTimeWhenExhausted = maxWaitTimeWhenExhausted;
    }

    public ExhaustedPolicy getExhaustedPolicy() {
        return this.exhaustedPolicy;
    }

    public void setExhaustedPolicy(ExhaustedPolicy exhaustedPolicy) {
        this.exhaustedPolicy = exhaustedPolicy;
    }

    public int getCassandraThriftSocketTimeout() {
        return this.cassandraThriftSocketTimeout;
    }

    public void setCassandraThriftSocketTimeout(int cassandraThriftSocketTimeout) {
        this.cassandraThriftSocketTimeout = cassandraThriftSocketTimeout;
    }

    public boolean getUseThriftFramedTransport() {
        return this.useThriftFramedTransport;
    }

    public void setUseThriftFramedTransport(boolean useThriftFramedTransport) {
        this.useThriftFramedTransport = useThriftFramedTransport;
    }

    public static String parseHostFromUrl(String urlPort) {
        return urlPort.substring(0, urlPort.lastIndexOf(58));
    }

    public static int parsePortFromUrl(String urlPort) {
        return Integer.valueOf(urlPort.substring(urlPort.lastIndexOf(58) + 1, urlPort.length()));
    }

    public void setTimestampResolution(TimestampResolution timestampResolution) {
        this.timestampResolution = timestampResolution;
    }

    public TimestampResolution getTimestampResolution() {
        return this.timestampResolution;
    }
}

