/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.ExhaustedPolicy;
import me.prettyprint.cassandra.service.TimestampResolution;

public class CassandraHostConfigurator {
    private String hosts;
    private int maxActive;
    private int maxIdle;
    private long maxWaitTimeWhenExhausted;
    private int cassandraThriftSocketTimeout;
    private ExhaustedPolicy exhaustedPolicy;
    private TimestampResolution timestampResolution;

    public CassandraHostConfigurator() {
        this.hosts = null;
    }

    public CassandraHostConfigurator(String hosts) {
        this.hosts = hosts;
    }

    public CassandraHost[] buildCassandraHosts() {
        if (this.hosts == null) {
            return null;
        }
        String[] hostVals = this.hosts.split(",");
        CassandraHost[] cassandraHosts = new CassandraHost[hostVals.length];
        for (int x = 0; x < hostVals.length; ++x) {
            CassandraHost cassandraHost = new CassandraHost(hostVals[x]);
            if (this.maxActive > 0) {
                cassandraHost.setMaxActive(this.maxActive);
            }
            if (this.maxIdle > 0) {
                cassandraHost.setMaxIdle(this.maxIdle);
            }
            if (this.maxWaitTimeWhenExhausted > 0L) {
                cassandraHost.setMaxWaitTimeWhenExhausted(this.maxWaitTimeWhenExhausted);
            }
            if (this.cassandraThriftSocketTimeout > 0) {
                cassandraHost.setCassandraThriftSocketTimeout(this.cassandraThriftSocketTimeout);
            }
            if (this.exhaustedPolicy != null) {
                cassandraHost.setExhaustedPolicy(this.exhaustedPolicy);
            }
            if (this.timestampResolution != null) {
                cassandraHost.setTimestampResolution(this.timestampResolution);
            }
            cassandraHosts[x] = cassandraHost;
        }
        return cassandraHosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMaxWaitTimeWhenExhausted(long maxWaitTimeWhenExhausted) {
        this.maxWaitTimeWhenExhausted = maxWaitTimeWhenExhausted;
    }

    public void setCassandraThriftSocketTimeout(int cassandraThriftSocketTimeout) {
        this.cassandraThriftSocketTimeout = cassandraThriftSocketTimeout;
    }

    public void setExhaustedPolicy(ExhaustedPolicy exhaustedPolicy) {
        this.exhaustedPolicy = exhaustedPolicy;
    }

    public void setTimestampResolution(String resolutionString) {
        this.timestampResolution = TimestampResolution.valueOf(resolutionString);
    }
}

