/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.lang.management.ManagementFactory;
import java.net.URL;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraClientPool;
import org.apache.log4j.xml.DOMConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum JmxMonitor {
    INSTANCE;

    private final Logger log = LoggerFactory.getLogger(JmxMonitor.class);
    private MBeanServer mbs;
    private CassandraClientMonitor cassandraClientMonitor;

    private JmxMonitor() {
        CassandraClientMonitor cassandraClientMonitor = new CassandraClientMonitor();
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.cassandraClientMonitor = cassandraClientMonitor;
        try {
            this.registerMonitor("me.prettyprint.cassandra.service", "hector", cassandraClientMonitor);
        }
        catch (MalformedObjectNameException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            this.log.error("Unable to register JMX monitor", (Throwable)e);
        }
    }

    public static JmxMonitor getInstance() {
        return INSTANCE;
    }

    public void addPool(CassandraClientPool pool) {
        this.cassandraClientMonitor.addPool(pool);
    }

    public void registerMonitor(String name, String monitorType, Object monitoringInterface) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String monitorName = this.generateMonitorName(name, monitorType);
        this.log.info("Registering JMX {}", (Object)monitorName);
        ObjectName oName = new ObjectName(monitorName);
        if (this.mbs.isRegistered(oName)) {
            this.log.info("Monitor already registered: {}", (Object)oName);
            return;
        }
        this.mbs.registerMBean(monitoringInterface, oName);
        this.registerPerf4J();
    }

    private void registerPerf4J() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("hectorLog4j.xml");
        if (url == null) {
            this.log.error("Unable to locate hectorLog4j.xml; performance counters will not be exported");
        } else {
            DOMConfigurator.configure((URL)url);
        }
    }

    private String generateMonitorName(String className, String monitorType) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(":ServiceType=");
        sb.append(this.getUniqueClassloaderIdentifier());
        if (null != monitorType && monitorType.length() > 0) {
            sb.append(",MonitorType=" + monitorType);
        }
        return sb.toString();
    }

    private String getUniqueClassloaderIdentifier() {
        String contextPath = this.getContextPath();
        if (contextPath != null) {
            return contextPath;
        }
        return "hector";
    }

    private String getContextPath() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("/");
        if (url != null) {
            String[] elements = url.toString().split("/");
            for (int i = elements.length - 1; i > 0; --i) {
                if (!"WEB-INF".equals(elements[i])) continue;
                return elements[i - 1];
            }
        }
        return null;
    }

    public CassandraClientMonitor getCassandraMonitor() {
        return this.cassandraClientMonitor;
    }
}

