/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.List;
import java.util.Map;
import me.prettyprint.cassandra.service.BatchMutation;
import me.prettyprint.cassandra.service.CassandraClient;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;

public interface Keyspace {
    public static final String CF_TYPE = "Type";
    public static final String CF_TYPE_STANDARD = "Standard";
    public static final String CF_TYPE_SUPER = "Super";

    public CassandraClient getClient();

    public Column getColumn(String var1, ColumnPath var2) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException;

    public SuperColumn getSuperColumn(String var1, ColumnPath var2) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException;

    public SuperColumn getSuperColumn(String var1, ColumnPath var2, boolean var3, int var4) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException;

    public List<Column> getSlice(String var1, ColumnParent var2, SlicePredicate var3) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException;

    public List<SuperColumn> getSuperSlice(String var1, ColumnParent var2, SlicePredicate var3) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException;

    public Map<String, Column> multigetColumn(List<String> var1, ColumnPath var2) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, SuperColumn> multigetSuperColumn(List<String> var1, ColumnPath var2) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, SuperColumn> multigetSuperColumn(List<String> var1, ColumnPath var2, boolean var3, int var4) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, List<Column>> multigetSlice(List<String> var1, ColumnParent var2, SlicePredicate var3) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, List<SuperColumn>> multigetSuperSlice(List<String> var1, ColumnParent var2, SlicePredicate var3) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public void insert(String var1, ColumnPath var2, byte[] var3) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public void batchInsert(String var1, Map<String, List<Column>> var2, Map<String, List<SuperColumn>> var3) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public void batchMutate(Map<String, Map<String, List<Mutation>>> var1) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public void batchMutate(BatchMutation var1) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public void remove(String var1, ColumnPath var2) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, Map<String, String>> describeKeyspace() throws NotFoundException, TException;

    public int getCount(String var1, ColumnParent var2) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, List<Column>> getRangeSlice(ColumnParent var1, SlicePredicate var2, String var3, String var4, int var5) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, List<Column>> getRangeSlices(ColumnParent var1, SlicePredicate var2, KeyRange var3) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public Map<String, List<SuperColumn>> getSuperRangeSlice(ColumnParent var1, SlicePredicate var2, String var3, String var4, int var5) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public ConsistencyLevel getConsistencyLevel();

    public String getName();

    public CassandraClient.FailoverPolicy getFailoverPolicy();
}

