/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.prettyprint.cassandra.service.BatchMutation;
import me.prettyprint.cassandra.service.CassandraClient;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraClientPool;
import me.prettyprint.cassandra.service.FailoverOperator;
import me.prettyprint.cassandra.service.Keyspace;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KeyRange;
import org.apache.cassandra.thrift.KeySlice;
import org.apache.cassandra.thrift.Mutation;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.SuperColumn;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyspaceImpl
implements Keyspace {
    private static final Logger log = LoggerFactory.getLogger(KeyspaceImpl.class);
    private CassandraClient client;
    private final String keyspaceName;
    private final Map<String, Map<String, String>> keyspaceDesc;
    private final ConsistencyLevel consistency;
    private final CassandraClient.FailoverPolicy failoverPolicy;
    private List<String> knownHosts = new ArrayList<String>();
    private final CassandraClientPool clientPools;
    private final CassandraClientMonitor monitor;

    public KeyspaceImpl(CassandraClient client, String keyspaceName, Map<String, Map<String, String>> keyspaceDesc, ConsistencyLevel consistencyLevel, CassandraClient.FailoverPolicy failoverPolicy, CassandraClientPool clientPools, CassandraClientMonitor monitor) throws TException {
        this.client = client;
        this.consistency = consistencyLevel;
        this.keyspaceDesc = keyspaceDesc;
        this.keyspaceName = keyspaceName;
        this.failoverPolicy = failoverPolicy;
        this.clientPools = clientPools;
        this.monitor = monitor;
        this.initFailover();
    }

    @Override
    public void batchInsert(final String key, Map<String, List<Column>> columnMap, Map<String, List<SuperColumn>> superColumnMap) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        if (columnMap == null && superColumnMap == null) {
            throw new InvalidRequestException("columnMap and SuperColumnMap can not be null at same time");
        }
        int size = (columnMap == null ? 0 : columnMap.size()) + (superColumnMap == null ? 0 : superColumnMap.size());
        final HashMap<String, List<ColumnOrSuperColumn>> cfmap = new HashMap<String, List<ColumnOrSuperColumn>>(size * 2);
        if (columnMap != null) {
            for (Map.Entry<String, List<Column>> entry : columnMap.entrySet()) {
                cfmap.put(entry.getKey(), KeyspaceImpl.getSoscList(entry.getValue()));
            }
        }
        if (superColumnMap != null) {
            for (Map.Entry<String, List<Column>> entry : superColumnMap.entrySet()) {
                cfmap.put(entry.getKey(), KeyspaceImpl.getSoscSuperList(entry.getValue()));
            }
        }
        Operation<Void> op = new Operation<Void>(OperationType.WRITE){

            @Override
            public Void execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                cassandra.batch_insert(KeyspaceImpl.this.keyspaceName, key, cfmap, KeyspaceImpl.this.consistency);
                return null;
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void batchMutate(final Map<String, Map<String, List<Mutation>>> mutationMap) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE){

            @Override
            public Void execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                cassandra.batch_mutate(KeyspaceImpl.this.keyspaceName, mutationMap, KeyspaceImpl.this.consistency);
                return null;
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public void batchMutate(BatchMutation batchMutate) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.batchMutate(batchMutate.getMutationMap());
    }

    @Override
    public int getCount(final String key, final ColumnParent columnParent) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Integer> op = new Operation<Integer>(OperationType.READ){

            @Override
            public Integer execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                return cassandra.get_count(KeyspaceImpl.this.keyspaceName, key, columnParent, KeyspaceImpl.this.consistency);
            }
        };
        this.operateWithFailover(op);
        return (Integer)op.getResult();
    }

    private void operateWithFailover(Operation<?> op) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        FailoverOperator operator = new FailoverOperator(this.failoverPolicy, this.knownHosts, this.monitor, this.client, this.clientPools, this);
        operator.operate(op);
    }

    @Override
    public Map<String, List<Column>> getRangeSlice(final ColumnParent columnParent, final SlicePredicate predicate, final String start, final String finish, final int count) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Map<String, List<Column>>> op = new Operation<Map<String, List<Column>>>(OperationType.READ){

            @Override
            public Map<String, List<Column>> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                List keySlices = cassandra.get_range_slice(KeyspaceImpl.this.keyspaceName, columnParent, predicate, start, finish, count, KeyspaceImpl.this.consistency);
                if (keySlices == null || keySlices.isEmpty()) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<String, List<Column>> ret = new LinkedHashMap<String, List<Column>>(keySlices.size());
                for (KeySlice keySlice : keySlices) {
                    ret.put(keySlice.getKey(), KeyspaceImpl.getColumnList(keySlice.getColumns()));
                }
                return ret;
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public Map<String, List<Column>> getRangeSlices(final ColumnParent columnParent, final SlicePredicate predicate, final KeyRange keyRange) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Map<String, List<Column>>> op = new Operation<Map<String, List<Column>>>(OperationType.READ){

            @Override
            public Map<String, List<Column>> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                List keySlices = cassandra.get_range_slices(KeyspaceImpl.this.keyspaceName, columnParent, predicate, keyRange, KeyspaceImpl.this.consistency);
                if (keySlices == null || keySlices.isEmpty()) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<String, List<Column>> ret = new LinkedHashMap<String, List<Column>>(keySlices.size());
                for (KeySlice keySlice : keySlices) {
                    ret.put(keySlice.getKey(), KeyspaceImpl.getColumnList(keySlice.getColumns()));
                }
                return ret;
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public Map<String, List<SuperColumn>> getSuperRangeSlice(final ColumnParent columnParent, final SlicePredicate predicate, final String start, final String finish, final int count) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Map<String, List<SuperColumn>>> op = new Operation<Map<String, List<SuperColumn>>>(OperationType.READ){

            @Override
            public Map<String, List<SuperColumn>> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                List keySlices = cassandra.get_range_slice(KeyspaceImpl.this.keyspaceName, columnParent, predicate, start, finish, count, KeyspaceImpl.this.consistency);
                if (keySlices == null || keySlices.isEmpty()) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<String, List<SuperColumn>> ret = new LinkedHashMap<String, List<SuperColumn>>(keySlices.size());
                for (KeySlice keySlice : keySlices) {
                    ret.put(keySlice.getKey(), KeyspaceImpl.getSuperColumnList(keySlice.getColumns()));
                }
                return ret;
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public List<Column> getSlice(final String key, final ColumnParent columnParent, final SlicePredicate predicate) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException {
        Operation<List<Column>> op = new Operation<List<Column>>(OperationType.READ){

            @Override
            public List<Column> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                List cosclist = cassandra.get_slice(KeyspaceImpl.this.keyspaceName, key, columnParent, predicate, KeyspaceImpl.this.consistency);
                if (cosclist == null) {
                    return null;
                }
                ArrayList<Column> result = new ArrayList<Column>(cosclist.size());
                for (ColumnOrSuperColumn cosc : cosclist) {
                    result.add(cosc.getColumn());
                }
                return result;
            }
        };
        this.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public SuperColumn getSuperColumn(String key, ColumnPath columnPath) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException {
        return this.getSuperColumn(key, columnPath, false, Integer.MAX_VALUE);
    }

    @Override
    public SuperColumn getSuperColumn(final String key, final ColumnPath columnPath, boolean reversed, int size) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException {
        this.valideSuperColumnPath(columnPath);
        final SliceRange sliceRange = new SliceRange(new byte[0], new byte[0], reversed, size);
        Operation<SuperColumn> op = new Operation<SuperColumn>(OperationType.READ){

            @Override
            public SuperColumn execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                ColumnParent clp = new ColumnParent(columnPath.getColumn_family());
                clp.setSuper_column(columnPath.getSuper_column());
                SlicePredicate sp = new SlicePredicate();
                sp.setSlice_range(sliceRange);
                List cosc = cassandra.get_slice(KeyspaceImpl.this.keyspaceName, key, clp, sp, KeyspaceImpl.this.consistency);
                return new SuperColumn(columnPath.getSuper_column(), KeyspaceImpl.getColumnList(cosc));
            }
        };
        this.operateWithFailover(op);
        return (SuperColumn)op.getResult();
    }

    @Override
    public List<SuperColumn> getSuperSlice(final String key, final ColumnParent columnParent, final SlicePredicate predicate) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException {
        Operation<List<SuperColumn>> op = new Operation<List<SuperColumn>>(OperationType.READ){

            @Override
            public List<SuperColumn> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                List cosclist = cassandra.get_slice(KeyspaceImpl.this.keyspaceName, key, columnParent, predicate, KeyspaceImpl.this.consistency);
                if (cosclist == null) {
                    return null;
                }
                ArrayList<SuperColumn> result = new ArrayList<SuperColumn>(cosclist.size());
                for (ColumnOrSuperColumn cosc : cosclist) {
                    result.add(cosc.getSuper_column());
                }
                return result;
            }
        };
        this.operateWithFailover(op);
        return (List)op.getResult();
    }

    @Override
    public void insert(final String key, final ColumnPath columnPath, final byte[] value) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.valideColumnPath(columnPath);
        Operation<Void> op = new Operation<Void>(OperationType.WRITE){

            @Override
            public Void execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                cassandra.insert(KeyspaceImpl.this.keyspaceName, key, columnPath, value, KeyspaceImpl.this.createTimeStamp(), KeyspaceImpl.this.consistency);
                return null;
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public Map<String, Column> multigetColumn(final List<String> keys, final ColumnPath columnPath) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.valideColumnPath(columnPath);
        Operation<Map<String, Column>> op = new Operation<Map<String, Column>>(OperationType.READ){

            @Override
            public Map<String, Column> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                Map cfmap = cassandra.multiget(KeyspaceImpl.this.keyspaceName, keys, columnPath, KeyspaceImpl.this.consistency);
                if (cfmap == null || cfmap.isEmpty()) {
                    return Collections.emptyMap();
                }
                HashMap<String, Column> result = new HashMap<String, Column>();
                for (Map.Entry entry : cfmap.entrySet()) {
                    result.put((String)entry.getKey(), ((ColumnOrSuperColumn)entry.getValue()).getColumn());
                }
                return result;
            }
        };
        this.operateWithFailover(op);
        return (Map)op.getResult();
    }

    @Override
    public Map<String, List<Column>> multigetSlice(final List<String> keys, final ColumnParent columnParent, final SlicePredicate predicate) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Map<String, List<Column>>> getCount = new Operation<Map<String, List<Column>>>(OperationType.READ){

            @Override
            public Map<String, List<Column>> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                Map cfmap = cassandra.multiget_slice(KeyspaceImpl.this.keyspaceName, keys, columnParent, predicate, KeyspaceImpl.this.consistency);
                HashMap<String, List<Column>> result = new HashMap<String, List<Column>>();
                for (Map.Entry entry : cfmap.entrySet()) {
                    result.put((String)entry.getKey(), KeyspaceImpl.getColumnList((List)entry.getValue()));
                }
                return result;
            }
        };
        this.operateWithFailover(getCount);
        return (Map)getCount.getResult();
    }

    @Override
    public Map<String, SuperColumn> multigetSuperColumn(List<String> keys, ColumnPath columnPath) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        return this.multigetSuperColumn(keys, columnPath, false, Integer.MAX_VALUE);
    }

    @Override
    public Map<String, SuperColumn> multigetSuperColumn(List<String> keys, ColumnPath columnPath, boolean reversed, int size) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.valideSuperColumnPath(columnPath);
        ColumnParent clp = new ColumnParent(columnPath.getColumn_family());
        clp.setSuper_column(columnPath.getSuper_column());
        SliceRange sr = new SliceRange(new byte[0], new byte[0], reversed, size);
        SlicePredicate sp = new SlicePredicate();
        sp.setSlice_range(sr);
        Map<String, List<SuperColumn>> sclist = this.multigetSuperSlice(keys, clp, sp);
        if (sclist == null || sclist.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, SuperColumn> result = new HashMap<String, SuperColumn>(keys.size() * 2);
        for (Map.Entry<String, List<SuperColumn>> entry : sclist.entrySet()) {
            List<SuperColumn> sclistByKey = entry.getValue();
            if (sclistByKey.size() <= 0) continue;
            result.put(entry.getKey(), sclistByKey.get(0));
        }
        return result;
    }

    @Override
    public Map<String, List<SuperColumn>> multigetSuperSlice(final List<String> keys, final ColumnParent columnParent, final SlicePredicate predicate) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Map<String, List<SuperColumn>>> getCount = new Operation<Map<String, List<SuperColumn>>>(OperationType.READ){

            @Override
            public Map<String, List<SuperColumn>> execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                Map cfmap = cassandra.multiget_slice(KeyspaceImpl.this.keyspaceName, keys, columnParent, predicate, KeyspaceImpl.this.consistency);
                if (columnParent.getSuper_column() == null) {
                    HashMap<String, List<SuperColumn>> result = new HashMap<String, List<SuperColumn>>();
                    for (Map.Entry entry : cfmap.entrySet()) {
                        result.put((String)entry.getKey(), KeyspaceImpl.getSuperColumnList((List)entry.getValue()));
                    }
                    return result;
                }
                HashMap<String, List<SuperColumn>> result = new HashMap<String, List<SuperColumn>>();
                for (Map.Entry entry : cfmap.entrySet()) {
                    SuperColumn spc = new SuperColumn(columnParent.getSuper_column(), KeyspaceImpl.getColumnList((List)entry.getValue()));
                    ArrayList<SuperColumn> spclist = new ArrayList<SuperColumn>(1);
                    spclist.add(spc);
                    result.put((String)entry.getKey(), (List<SuperColumn>)spclist);
                }
                return result;
            }
        };
        this.operateWithFailover(getCount);
        return (Map)getCount.getResult();
    }

    @Override
    public void remove(final String key, final ColumnPath columnPath) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        Operation<Void> op = new Operation<Void>(OperationType.WRITE){

            @Override
            public Void execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                cassandra.remove(KeyspaceImpl.this.keyspaceName, key, columnPath, KeyspaceImpl.this.createTimeStamp(), KeyspaceImpl.this.consistency);
                return null;
            }
        };
        this.operateWithFailover(op);
    }

    @Override
    public String getName() {
        return this.keyspaceName;
    }

    @Override
    public Map<String, Map<String, String>> describeKeyspace() throws NotFoundException, TException {
        return this.keyspaceDesc;
    }

    @Override
    public CassandraClient getClient() {
        return this.client;
    }

    @Override
    public Column getColumn(final String key, final ColumnPath columnPath) throws InvalidRequestException, NotFoundException, UnavailableException, TException, TimedOutException {
        this.valideColumnPath(columnPath);
        Operation<Column> op = new Operation<Column>(OperationType.READ){

            @Override
            public Column execute(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
                ColumnOrSuperColumn cosc;
                try {
                    cosc = cassandra.get(KeyspaceImpl.this.keyspaceName, key, columnPath, KeyspaceImpl.this.consistency);
                }
                catch (NotFoundException e) {
                    this.setException(e);
                    return null;
                }
                return cosc == null ? null : cosc.getColumn();
            }
        };
        this.operateWithFailover(op);
        if (op.hasException()) {
            throw op.getException();
        }
        return (Column)op.getResult();
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    long createTimeStamp() {
        long current = System.currentTimeMillis();
        switch (this.client.getTimestampResolution()) {
            case MICROSECONDS: {
                return current * 1000L;
            }
            case MILLISECONDS: {
                return current;
            }
            case SECONDS: {
                return current / 1000L;
            }
        }
        throw new RuntimeException("Unknown TimestampResolution: " + (Object)((Object)this.client.getTimestampResolution()));
    }

    private void valideColumnPath(ColumnPath columnPath) throws InvalidRequestException {
        String cf = columnPath.getColumn_family();
        Map<String, String> cfdefine = this.keyspaceDesc.get(cf);
        if (cfdefine != null) {
            if (cfdefine.get("Type").equals("Standard") && columnPath.getColumn() != null) {
                return;
            }
            if (cfdefine.get("Type").equals("Super") && columnPath.getSuper_column() != null && columnPath.getColumn() != null) {
                return;
            }
        }
        throw new InvalidRequestException("The specified column family does not exist: " + cf);
    }

    private void valideSuperColumnPath(ColumnPath columnPath) throws InvalidRequestException {
        String cf = columnPath.getColumn_family();
        Map<String, String> cfdefine = this.keyspaceDesc.get(cf);
        if (cfdefine != null && cfdefine.get("Type").equals("Super") && columnPath.getSuper_column() != null) {
            return;
        }
        throw new InvalidRequestException("Invalid super column or super column family does not exist: " + cf);
    }

    private static List<ColumnOrSuperColumn> getSoscList(List<Column> columns) {
        ArrayList<ColumnOrSuperColumn> list = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (Column col : columns) {
            ColumnOrSuperColumn columnOrSuperColumn = new ColumnOrSuperColumn();
            columnOrSuperColumn.setColumn(col);
            list.add(columnOrSuperColumn);
        }
        return list;
    }

    private static List<ColumnOrSuperColumn> getSoscSuperList(List<SuperColumn> columns) {
        ArrayList<ColumnOrSuperColumn> list = new ArrayList<ColumnOrSuperColumn>(columns.size());
        for (SuperColumn col : columns) {
            ColumnOrSuperColumn columnOrSuperColumn = new ColumnOrSuperColumn();
            columnOrSuperColumn.setSuper_column(col);
            list.add(columnOrSuperColumn);
        }
        return list;
    }

    private static List<Column> getColumnList(List<ColumnOrSuperColumn> columns) {
        ArrayList<Column> list = new ArrayList<Column>(columns.size());
        for (ColumnOrSuperColumn col : columns) {
            list.add(col.getColumn());
        }
        return list;
    }

    private static List<SuperColumn> getSuperColumnList(List<ColumnOrSuperColumn> columns) {
        ArrayList<SuperColumn> list = new ArrayList<SuperColumn>(columns.size());
        for (ColumnOrSuperColumn col : columns) {
            list.add(col.getSuper_column());
        }
        return list;
    }

    @Override
    public CassandraClient.FailoverPolicy getFailoverPolicy() {
        return this.failoverPolicy;
    }

    private void initFailover() throws TException {
        if (this.failoverPolicy == CassandraClient.FailoverPolicy.FAIL_FAST) {
            this.knownHosts.clear();
            this.knownHosts.add(this.client.getUrl());
            return;
        }
        this.updateKnownHosts();
    }

    public void updateKnownHosts() throws TException {
        this.knownHosts.clear();
        this.knownHosts.add(this.getClient().getUrl());
        try {
            Map<String, String> map = this.getClient().getTokenMap(true);
            this.knownHosts.clear();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.knownHosts.add(entry.getValue());
            }
        }
        catch (TException e) {
            this.knownHosts.clear();
            log.error("Cannot query tokenMap; Keyspace {} is now disconnected", (Object)this.toString());
        }
    }

    public Set<String> getKnownHosts() {
        HashSet<String> hosts = new HashSet<String>();
        hosts.addAll(this.knownHosts);
        return hosts;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("KeyspaceImpl<");
        b.append(this.getClient());
        b.append(">");
        return super.toString();
    }
}

