/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.OperationType;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.NotFoundException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;

abstract class Operation<T> {
    protected final CassandraClientMonitor.Counter failCounter;
    protected final String stopWatchTagName;
    protected T result;
    private NotFoundException exception;

    public Operation(OperationType operationType) {
        this.failCounter = operationType.equals((Object)OperationType.READ) ? CassandraClientMonitor.Counter.READ_FAIL : CassandraClientMonitor.Counter.WRITE_FAIL;
        this.stopWatchTagName = operationType.name();
    }

    public void setResult(T executionResult) {
        this.result = executionResult;
    }

    public T getResult() {
        return this.result;
    }

    public abstract T execute(Cassandra.Client var1) throws InvalidRequestException, UnavailableException, TException, TimedOutException;

    public void executeAndSetResult(Cassandra.Client cassandra) throws InvalidRequestException, UnavailableException, TException, TimedOutException {
        this.setResult(this.execute(cassandra));
    }

    public void setException(NotFoundException e) {
        this.exception = e;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public NotFoundException getException() {
        return this.exception;
    }
}

