/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.testutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cassandra.contrib.utils.service.CassandraServiceDataCleaner;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.EmbeddedCassandraService;
import org.apache.thrift.transport.TTransportException;

public class EmbeddedServerHelper {
    private static final String TMP = "tmp";
    private EmbeddedCassandraService cassandra;

    public void setup() throws TTransportException, IOException, InterruptedException {
        EmbeddedServerHelper.rmdir(TMP);
        EmbeddedServerHelper.copy("/storage-conf.xml", TMP);
        EmbeddedServerHelper.copy("/log4j.properties", TMP);
        System.setProperty("storage-config", TMP);
        CassandraServiceDataCleaner cleaner = new CassandraServiceDataCleaner();
        cleaner.prepare();
        this.cassandra = new EmbeddedCassandraService();
        this.cassandra.init();
        Thread t = new Thread((Runnable)this.cassandra);
        t.setDaemon(true);
        t.start();
    }

    public void teardown() {
        CassandraServiceDataCleaner cleaner = new CassandraServiceDataCleaner();
        try {
            cleaner.cleanupDataDirectories();
            EmbeddedServerHelper.rmdir(TMP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void rmdir(String dir) throws IOException {
        File dirFile = new File(dir);
        if (dirFile.exists()) {
            FileUtils.deleteDir((File)new File(dir));
        }
    }

    private static void copy(String resource, String directory) throws IOException {
        int len;
        EmbeddedServerHelper.mkdir(directory);
        InputStream is = EmbeddedServerHelper.class.getResourceAsStream(resource);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        File file = new File(directory + System.getProperty("file.separator") + fileName);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        is.close();
    }

    private static void mkdir(String dir) throws IOException {
        FileUtils.createDirectory((String)dir);
    }
}

