/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.yun.core.filter;

import com.baidu.yun.core.annotation.HttpParamKeyName;
import com.baidu.yun.core.annotation.R;
import com.baidu.yun.core.filter.IFieldFilter;
import com.baidu.yun.core.utility.StringUtility;
import com.baidu.yun.core.utility.YunCommonUtility;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpParamKeyNameFilter
implements IFieldFilter {
    @Override
    public void validate(Field field, Object req) throws Exception {
        HttpParamKeyName annotation;
        Object obj;
        if (field.isAnnotationPresent(HttpParamKeyName.class) && (obj = field.get(req)) == null && (annotation = field.getAnnotation(HttpParamKeyName.class)).param() == R.REQUIRE) {
            throw new Exception(String.valueOf(field.getName()) + " is null, default require");
        }
    }

    @Override
    public void mapping(Field field, Object req, Map<String, String> params) throws Exception {
        if (field.isAnnotationPresent(HttpParamKeyName.class)) {
            Object obj = field.get(req);
            if (obj == null) {
                return;
            }
            HttpParamKeyName annotation = field.getAnnotation(HttpParamKeyName.class);
            Class<?> zlass = field.getType();
            if (zlass.equals(Long.class) || "long".equalsIgnoreCase(zlass.getName())) {
                params.put(annotation.name(), obj.toString());
            } else if (zlass.equals(Integer.class) || "int".equalsIgnoreCase(zlass.getName())) {
                params.put(annotation.name(), obj.toString());
            } else if (zlass.equals(String.class)) {
                params.put(annotation.name(), (String)obj);
            } else if (zlass.equals(Date.class)) {
                params.put(annotation.name(), YunCommonUtility.formatFromDate((Date)obj));
            } else if (zlass.isEnum()) {
                params.put(annotation.name(), obj.toString());
            } else if (zlass.equals(List.class)) {
                params.put(annotation.name(), StringUtility.toJson((List)obj));
            } else if (zlass.equals(Set.class)) {
                params.put(annotation.name(), StringUtility.toJson((Set)obj));
            }
        }
    }
}

