/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.yun.core.httpclient;

import com.baidu.yun.core.callback.YunHttpObservable;
import com.baidu.yun.core.callback.YunHttpObserver;
import com.baidu.yun.core.config.HttpConfigure;
import com.baidu.yun.core.event.YunHttpEvent;
import com.baidu.yun.core.exception.YunHttpClientException;
import com.baidu.yun.core.model.HttpRestResponse;
import com.baidu.yun.core.utility.IOUtility;
import com.baidu.yun.core.utility.MessageDigestUtility;
import com.baidu.yun.core.utility.Native2AsciiUtility;
import com.baidu.yun.push.exception.PushClientException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class YunHttpClient
implements YunHttpObservable {
    private static Logger logger = Logger.getLogger(YunHttpClient.class.getName());
    private List<YunHttpObserver> listeners = Collections.synchronizedList(new LinkedList());
    private HttpConfigure httpConfigure = new HttpConfigure();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpRestResponse doExecutePostRequestResponse(String surl, Map<String, String> params) throws YunHttpClientException {
        HttpURLConnection conn = null;
        InputStream is = null;
        InputStream err = null;
        int httpStatusCode = -1;
        String responseContent = null;
        String paramsContent = this.concatHttpParams(params);
        String locationUrl = null;
        boolean redirectable = false;
        int maxRetryTimes = 1;
        if (this.httpConfigure != null) {
            maxRetryTimes = this.httpConfigure.getMaxRetryTimes();
        }
        int i = 0;
        while (true) {
            block28: {
                HttpRestResponse httpRestResponse;
                block32: {
                    block31: {
                        HttpRestResponse httpRestResponse2;
                        block29: {
                            if (i >= maxRetryTimes) {
                                httpStatusCode = 404;
                                responseContent = "Connect web server fail, retry time more than threshold";
                                this.notifyAndCallback(new YunHttpEvent(10004, surl, paramsContent, httpStatusCode, responseContent));
                                throw new YunHttpClientException("Network connect fail, domain [api.tuisong.baidu.com] exists?");
                            }
                            responseContent = null;
                            httpStatusCode = -1;
                            try {
                                URL url = null;
                                if (!redirectable) {
                                    url = new URL(surl);
                                } else {
                                    url = new URL(locationUrl);
                                    redirectable = false;
                                    locationUrl = null;
                                }
                                conn = (HttpURLConnection)url.openConnection();
                                if (conn instanceof HttpsURLConnection) {
                                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                                        @Override
                                        public boolean verify(String hostname, SSLSession session) {
                                            return true;
                                        }
                                    });
                                    TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                                        @Override
                                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                        }

                                        @Override
                                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                        }

                                        @Override
                                        public X509Certificate[] getAcceptedIssuers() {
                                            return null;
                                        }
                                    }};
                                    SSLContext sslContext = SSLContext.getInstance("SSL");
                                    sslContext.init(null, tm, new SecureRandom());
                                    SSLSocketFactory ssf = sslContext.getSocketFactory();
                                    ((HttpsURLConnection)conn).setSSLSocketFactory(ssf);
                                }
                                if (this.httpConfigure != null) {
                                    conn.setConnectTimeout(this.httpConfigure.getMaxTimeout());
                                    conn.setReadTimeout(this.httpConfigure.getMaxTimeout());
                                    if (this.httpConfigure.isRelocationable()) {
                                        conn.setInstanceFollowRedirects(true);
                                    }
                                }
                                conn.setRequestMethod("POST");
                                this.configureConnection(conn);
                                conn.connect();
                            }
                            catch (Exception e) {
                                conn.disconnect();
                                if (i + 1 >= maxRetryTimes) {
                                    this.notifyAndCallback(new YunHttpEvent(10001, surl, paramsContent, httpStatusCode, "Network connect fail, domain[api.tuisong.baidu.com] exists?"));
                                    throw new YunHttpClientException("Network connect fail, domain[api.tuisong.baidu.com] exists?");
                                }
                                break block28;
                            }
                            try {
                                OutputStream os = conn.getOutputStream();
                                os.write(paramsContent.getBytes());
                                os.flush();
                                os.close();
                                httpStatusCode = conn.getResponseCode();
                                if (httpStatusCode == 200) {
                                    is = conn.getInputStream();
                                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                                    responseContent = IOUtility.readContentFromReader(reader);
                                    this.notifyAndCallback(new YunHttpEvent(0, surl, paramsContent, httpStatusCode, responseContent));
                                    HttpRestResponse response = new HttpRestResponse();
                                    response.setHttpStatusCode(httpStatusCode);
                                    if (responseContent != null) {
                                        responseContent = Native2AsciiUtility.ascii2Native(responseContent);
                                    }
                                    response.setJsonResponse(responseContent);
                                    httpRestResponse2 = response;
                                    IOUtility.closeInputStream(is);
                                    break block29;
                                }
                                if (httpStatusCode == 301 || httpStatusCode == 302) {
                                    if (this.httpConfigure != null && this.httpConfigure.isRelocationable()) {
                                        String location = conn.getHeaderField("location");
                                        if (location != null) {
                                            redirectable = true;
                                            locationUrl = location;
                                            --i;
                                            this.notifyAndCallback(new YunHttpEvent(1, surl, paramsContent, httpStatusCode, "redirect to " + locationUrl));
                                        } else {
                                            this.notifyAndCallback(new YunHttpEvent(1, surl, paramsContent, httpStatusCode, "header location is null, so give up to redirect"));
                                        }
                                    } else {
                                        this.notifyAndCallback(new YunHttpEvent(1, surl, paramsContent, httpStatusCode, "web server suggest redirect, but client don't support it"));
                                    }
                                    IOUtility.closeInputStream(is);
                                    break block31;
                                }
                                err = conn.getErrorStream();
                                responseContent = IOUtility.readContentFromInputStream(err);
                                this.notifyAndCallback(new YunHttpEvent(1, surl, paramsContent, httpStatusCode, responseContent));
                                HttpRestResponse response = new HttpRestResponse();
                                response.setHttpStatusCode(httpStatusCode);
                                if (responseContent != null) {
                                    responseContent = Native2AsciiUtility.ascii2Native(responseContent);
                                }
                                responseContent = responseContent == null || responseContent.length() == 0 ? null : this.getErrorMsgFromException(responseContent);
                                response.setJsonResponse(responseContent);
                                httpRestResponse = response;
                                IOUtility.closeInputStream(is);
                                break block32;
                            }
                            catch (Exception e) {
                                this.notifyAndCallback(new YunHttpEvent(10002, surl, paramsContent, httpStatusCode, e.getMessage()));
                                break block28;
                            }
                        }
                        IOUtility.closeInputStream(err);
                        if (conn == null) return httpRestResponse2;
                        conn.disconnect();
                        return httpRestResponse2;
                    }
                    IOUtility.closeInputStream(err);
                    if (conn != null) {
                        conn.disconnect();
                    }
                    break block28;
                }
                IOUtility.closeInputStream(err);
                if (conn == null) return httpRestResponse;
                conn.disconnect();
                return httpRestResponse;
                finally {
                    IOUtility.closeInputStream(is);
                    IOUtility.closeInputStream(err);
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            ++i;
        }
    }

    private void configureConnection(HttpURLConnection conn) {
        StringBuilder userAgentBuilder = new StringBuilder();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        String sysName = this.getLocalHostSysName();
        String sysVersion = this.getLocalHostSysVersion();
        String sysArch = this.getLocalHostSysArch();
        String sysLangVersion = this.getLocalSysLangVersion();
        userAgentBuilder.append("BCCS_SDK/3.0 (");
        if (sysName != null) {
            userAgentBuilder.append(sysName).append("; ");
        }
        if (sysVersion != null) {
            userAgentBuilder.append(sysVersion).append("; ");
        }
        if (sysArch != null) {
            userAgentBuilder.append(sysArch);
        }
        userAgentBuilder.append(") ").append("JAVA/").append(sysLangVersion).append(" (Baidu Push Server SDK V.2.0.0)");
        conn.setRequestProperty("User-Agent", userAgentBuilder.toString());
    }

    private String concatHttpParams(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = false;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!isFirst) {
                isFirst = true;
            } else {
                sb.append('&');
            }
            sb.append(entry.getKey());
            sb.append('=');
            if (MessageDigestUtility.urlEncode(entry.getValue()) != null) {
                sb.append(MessageDigestUtility.urlEncode(entry.getValue()));
                continue;
            }
            new PushClientException(String.valueOf(entry.getKey()) + ": value is not encoded by UTF-8");
        }
        return sb.toString();
    }

    @Override
    public void addHttpCallback(YunHttpObserver callback) {
        if (!this.listeners.contains(callback)) {
            this.listeners.add(callback);
        }
    }

    @Override
    public void addBatchHttpCallBack(List<YunHttpObserver> callbacks) {
        for (YunHttpObserver callback : callbacks) {
            this.addHttpCallback(callback);
        }
    }

    @Override
    public void removeCallBack(YunHttpObserver callback) {
        this.listeners.remove(callback);
    }

    @Override
    public void notifyAndCallback(YunHttpEvent event) {
        for (YunHttpObserver callback : this.listeners) {
            callback.onHandle(event);
        }
    }

    private String getLocalHostSysName() {
        String sysName = null;
        try {
            sysName = System.getProperty("os.name");
            return sysName;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private String getLocalHostSysArch() {
        String sysArch = null;
        try {
            sysArch = System.getProperty("os.arch");
            return sysArch;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private String getLocalHostSysVersion() {
        String sysVersion = null;
        try {
            sysVersion = System.getProperty("os.version");
            return sysVersion;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private String getLocalSysLangVersion() {
        String sysLanguageVersion = null;
        try {
            sysLanguageVersion = System.getProperty("java.version");
            return sysLanguageVersion;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private String getErrorMsgFromException(String serverException) {
        int index = serverException.indexOf("</pre>");
        if (index > 0) {
            int startIndex = index + 6;
            StringBuilder errorMsg = new StringBuilder();
            int i = startIndex;
            while (i < serverException.length()) {
                errorMsg.append(serverException.charAt(i));
                ++i;
            }
            System.out.println(errorMsg.toString());
            return errorMsg.toString();
        }
        return serverException;
    }
}

